/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.health;

import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.quarkus.runtime.api.session.QuarkusCqlSession;
import io.quarkus.arc.Arc;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class CassandraHealthCheck
implements HealthCheck {
    private static final String HEALTH_CHECK_NAME = "DataStax Apache Cassandra Driver health check";
    static final String HEALTH_CHECK_QUERY = "SELECT data_center, release_version, cluster_name, cql_version FROM system.local";
    private QuarkusCqlSession cqlSession;

    public QuarkusCqlSession beanProvider() {
        return (QuarkusCqlSession)Arc.container().instance(QuarkusCqlSession.class, new Annotation[0]).get();
    }

    @PostConstruct
    protected void init() {
        this.cqlSession = this.beanProvider();
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)HEALTH_CHECK_NAME).up();
        try {
            Row result = (Row)this.cqlSession.execute(HEALTH_CHECK_QUERY).one();
            if (result == null) {
                return builder.down().withData("reason", "system.local returned null").build();
            }
            for (Map.Entry<String, String> entry : this.extractInfoFromResult(result).entrySet()) {
                builder.withData(entry.getKey(), entry.getValue());
            }
            return builder.withData("numberOfNodes", (long)this.cqlSession.getMetadata().getNodes().size()).up().build();
        }
        catch (Exception ex) {
            return builder.down().withData("reason", ex.getMessage()).build();
        }
    }

    private Map<String, String> extractInfoFromResult(Row result) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("datacenter", result.getString("data_center"));
        details.put("releaseVersion", result.getString("release_version"));
        details.put("clusterName", result.getString("cluster_name"));
        details.put("cqlVersion", result.getString("cql_version"));
        return details;
    }
}

