/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.mapper;

import com.datastax.dse.driver.api.core.cql.reactive.ReactiveResultSet;
import com.datastax.dse.driver.internal.mapper.reactive.DefaultMappedReactiveResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.api.mapper.entity.EntityHelper;
import com.datastax.oss.driver.api.mapper.result.MapperResultProducer;
import com.datastax.oss.quarkus.runtime.internal.reactive.DefaultMutinyMappedReactiveResultSet;
import com.datastax.oss.quarkus.runtime.internal.reactive.DefaultMutinyReactiveResultSet;
import com.datastax.oss.quarkus.runtime.internal.reactive.FailedMutinyMappedReactiveResultSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.smallrye.mutiny.Multi;

public class MutinyMultiResultProducer
implements MapperResultProducer {
    public boolean canProduce(@NonNull GenericType<?> resultType) {
        return Multi.class.isAssignableFrom(resultType.getRawType());
    }

    public Object execute(@NonNull Statement<?> statement, @NonNull MapperContext context, @Nullable EntityHelper<?> entityHelper) {
        ReactiveResultSet source = context.getSession().executeReactive(statement);
        if (entityHelper == null) {
            return new DefaultMutinyReactiveResultSet(source);
        }
        return new DefaultMutinyMappedReactiveResultSet(new DefaultMappedReactiveResultSet(source, arg_0 -> entityHelper.get(arg_0)));
    }

    @Nullable
    public Object wrapError(@NonNull Exception e) {
        return new FailedMutinyMappedReactiveResultSet(e);
    }
}

