/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.mapper;

import com.datastax.dse.driver.api.core.cql.reactive.ReactiveResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.GettableByName;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.api.mapper.entity.EntityHelper;
import com.datastax.oss.driver.api.mapper.result.MapperResultProducer;
import com.datastax.oss.quarkus.runtime.internal.reactive.Wrappers;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.smallrye.mutiny.Uni;

public class MutinyUniResultProducer
implements MapperResultProducer {
    public boolean canProduce(@NonNull GenericType<?> resultType) {
        return Uni.class.equals((Object)resultType.getRawType());
    }

    public Object execute(@NonNull Statement<?> statement, @NonNull MapperContext context, @Nullable EntityHelper<?> entityHelper) {
        ReactiveResultSet source = context.getSession().executeReactive(statement);
        if (entityHelper == null) {
            return Wrappers.toUni(source);
        }
        return Wrappers.toUni(source).map(row -> row == null ? null : entityHelper.get((GettableByName)row));
    }

    @Nullable
    public Object wrapError(@NonNull Exception e) {
        return Wrappers.failedUni(e);
    }
}

