/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.metrics;

import com.datastax.dse.driver.api.core.metrics.DseNodeMetric;
import com.datastax.dse.driver.api.core.metrics.DseSessionMetric;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopNodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopSessionMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.quarkus.runtime.internal.metrics.MicroProfileNodeMetricUpdater;
import com.datastax.oss.quarkus.runtime.internal.metrics.MicroProfileSessionMetricUpdater;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroProfileMetricsFactory
implements MetricsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MicroProfileMetricsFactory.class);
    private final String logPrefix;
    private final InternalDriverContext context;
    private final Set<NodeMetric> enabledNodeMetrics;
    private final MetricRegistry registry;
    private final SessionMetricUpdater sessionUpdater;

    public MicroProfileMetricsFactory(InternalDriverContext context, MetricRegistry metricRegistry) {
        this.logPrefix = context.getSessionName();
        this.context = context;
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        Set<SessionMetric> enabledSessionMetrics = this.parseSessionMetricPaths(config.getStringList((DriverOption)DefaultDriverOption.METRICS_SESSION_ENABLED));
        this.enabledNodeMetrics = this.parseNodeMetricPaths(config.getStringList((DriverOption)DefaultDriverOption.METRICS_NODE_ENABLED));
        if (enabledSessionMetrics.isEmpty() && this.enabledNodeMetrics.isEmpty()) {
            LOG.debug("[{}] All metrics are disabled.", (Object)this.logPrefix);
            this.registry = null;
            this.sessionUpdater = NoopSessionMetricUpdater.INSTANCE;
        } else {
            this.registry = metricRegistry;
            this.sessionUpdater = new MicroProfileSessionMetricUpdater(enabledSessionMetrics, this.registry, context);
        }
    }

    public Optional<Metrics> getMetrics() {
        throw new UnsupportedOperationException("getMetrics() is not supported in Quarkus. The driver publishes its metrics directly to the vendor MetricRegistry of the container.");
    }

    public SessionMetricUpdater getSessionUpdater() {
        return this.sessionUpdater;
    }

    public NodeMetricUpdater newNodeUpdater(Node node) {
        return this.registry == null ? NoopNodeMetricUpdater.INSTANCE : new MicroProfileNodeMetricUpdater(node, this.enabledNodeMetrics, this.registry, this.context);
    }

    protected Set<SessionMetric> parseSessionMetricPaths(List<String> paths) {
        HashSet<Object> result = new HashSet<Object>();
        for (String path : paths) {
            try {
                result.add(DefaultSessionMetric.fromPath((String)path));
            }
            catch (IllegalArgumentException e) {
                try {
                    result.add(DseSessionMetric.fromPath((String)path));
                }
                catch (IllegalArgumentException e1) {
                    LOG.warn("[{}] Unknown session metric {}, skipping", (Object)this.logPrefix, (Object)path);
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }

    protected Set<NodeMetric> parseNodeMetricPaths(List<String> paths) {
        HashSet<Object> result = new HashSet<Object>();
        for (String path : paths) {
            try {
                result.add(DefaultNodeMetric.fromPath((String)path));
            }
            catch (IllegalArgumentException e) {
                try {
                    result.add(DseNodeMetric.fromPath((String)path));
                }
                catch (IllegalArgumentException e1) {
                    LOG.warn("[{}] Unknown node metric {}, skipping", (Object)this.logPrefix, (Object)path);
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }
}

