/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.metrics;

import com.datastax.dse.driver.api.core.metrics.DseNodeMetric;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.quarkus.runtime.internal.metrics.MicroProfileMetricsUpdater;
import java.util.Set;
import java.util.function.Function;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;

@ThreadSafe
public class MicroProfileNodeMetricUpdater
extends MicroProfileMetricsUpdater<NodeMetric>
implements NodeMetricUpdater {
    private final String metricNamePrefix;

    public MicroProfileNodeMetricUpdater(Node node, Set<NodeMetric> enabledMetrics, MetricRegistry registry, InternalDriverContext context) {
        super(enabledMetrics, registry);
        this.metricNamePrefix = this.buildPrefix(context.getSessionName(), node.getEndPoint());
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        if (enabledMetrics.contains(DefaultNodeMetric.OPEN_CONNECTIONS)) {
            this.registry.register(this.buildFullName((NodeMetric)DefaultNodeMetric.OPEN_CONNECTIONS, (String)null), (Metric)((Gauge)() -> ((Node)node).getOpenConnections()));
        }
        this.initializePoolGauge((NodeMetric)DefaultNodeMetric.AVAILABLE_STREAMS, node, ChannelPool::getAvailableIds, context);
        this.initializePoolGauge((NodeMetric)DefaultNodeMetric.IN_FLIGHT, node, ChannelPool::getInFlight, context);
        this.initializePoolGauge((NodeMetric)DefaultNodeMetric.ORPHANED_STREAMS, node, ChannelPool::getOrphanedIds, context);
        this.initializeTimer(DefaultNodeMetric.CQL_MESSAGES, config);
        this.initializeDefaultCounter(DefaultNodeMetric.UNSENT_REQUESTS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.ABORTED_REQUESTS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.WRITE_TIMEOUTS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.READ_TIMEOUTS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.UNAVAILABLES, null);
        this.initializeDefaultCounter(DefaultNodeMetric.OTHER_ERRORS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_ABORTED, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_READ_TIMEOUT, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_WRITE_TIMEOUT, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_UNAVAILABLE, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_OTHER_ERROR, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_ABORTED, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_READ_TIMEOUT, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_WRITE_TIMEOUT, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_UNAVAILABLE, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_OTHER_ERROR, null);
        this.initializeDefaultCounter(DefaultNodeMetric.SPECULATIVE_EXECUTIONS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.CONNECTION_INIT_ERRORS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.AUTHENTICATION_ERRORS, null);
        this.initializeTimer(DseNodeMetric.GRAPH_MESSAGES, context.getConfig().getDefaultProfile());
    }

    @Override
    public String buildFullName(NodeMetric metric, String profileName) {
        return "cassandra." + this.metricNamePrefix + metric.getPath();
    }

    private String buildPrefix(String sessionName, EndPoint endPoint) {
        return sessionName + ".nodes." + endPoint.asMetricPrefix() + ".";
    }

    private void initializePoolGauge(NodeMetric metric, Node node, Function<ChannelPool, Integer> reading, InternalDriverContext context) {
        if (this.enabledMetrics.contains(metric)) {
            this.registry.register(this.buildFullName(metric, (String)null), (Metric)((Gauge)() -> {
                ChannelPool pool = (ChannelPool)context.getPoolManager().getPools().get(node);
                return pool == null ? Integer.valueOf(0) : (Integer)reading.apply(pool);
            }));
        }
    }
}

