/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.metrics;

import com.datastax.dse.driver.api.core.metrics.DseSessionMetric;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.api.core.session.throttling.RequestThrottler;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.CqlPrepareAsyncProcessor;
import com.datastax.oss.driver.internal.core.cql.CqlPrepareSyncProcessor;
import com.datastax.oss.driver.internal.core.metrics.DropwizardSessionMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.datastax.oss.driver.internal.core.session.throttling.ConcurrencyLimitingRequestThrottler;
import com.datastax.oss.driver.internal.core.session.throttling.RateLimitingRequestThrottler;
import com.datastax.oss.driver.shaded.guava.common.cache.Cache;
import com.datastax.oss.quarkus.runtime.internal.metrics.MicroProfileMetricsUpdater;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Set;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroProfileSessionMetricUpdater
extends MicroProfileMetricsUpdater<SessionMetric>
implements SessionMetricUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(DropwizardSessionMetricUpdater.class);
    private final String metricNamePrefix;

    public MicroProfileSessionMetricUpdater(Set<SessionMetric> enabledMetrics, MetricRegistry registry, InternalDriverContext context) {
        super(enabledMetrics, registry);
        this.metricNamePrefix = context.getSessionName() + ".";
        if (enabledMetrics.contains(DefaultSessionMetric.CONNECTED_NODES)) {
            this.registry.register(this.buildFullName((SessionMetric)DefaultSessionMetric.CONNECTED_NODES, (String)null), (Metric)((Gauge)() -> {
                int count = 0;
                for (Node node : context.getMetadataManager().getMetadata().getNodes().values()) {
                    if (node.getOpenConnections() <= 0) continue;
                    ++count;
                }
                return count;
            }));
        }
        if (enabledMetrics.contains(DefaultSessionMetric.THROTTLING_QUEUE_SIZE)) {
            this.registry.register(this.buildFullName((SessionMetric)DefaultSessionMetric.THROTTLING_QUEUE_SIZE, (String)null), this.buildQueueGauge(context.getRequestThrottler(), context.getSessionName()));
        }
        if (enabledMetrics.contains(DefaultSessionMetric.CQL_PREPARED_CACHE_SIZE)) {
            this.registry.register(this.buildFullName((SessionMetric)DefaultSessionMetric.CQL_PREPARED_CACHE_SIZE, (String)null), this.createPreparedStatementsGauge(context));
        }
        this.initializeTimer(DefaultSessionMetric.CQL_REQUESTS, context.getConfig().getDefaultProfile());
        this.initializeDefaultCounter(DefaultSessionMetric.CQL_CLIENT_TIMEOUTS, null);
        this.initializeTimer(DefaultSessionMetric.THROTTLING_DELAY, context.getConfig().getDefaultProfile());
        this.initializeDefaultCounter(DefaultSessionMetric.THROTTLING_ERRORS, null);
        this.initializeTimer(DseSessionMetric.CONTINUOUS_CQL_REQUESTS, context.getConfig().getDefaultProfile());
        this.initializeDefaultCounter(DseSessionMetric.GRAPH_CLIENT_TIMEOUTS, null);
        this.initializeTimer(DseSessionMetric.GRAPH_REQUESTS, context.getConfig().getDefaultProfile());
    }

    private Gauge<Long> createPreparedStatementsGauge(InternalDriverContext context) {
        Gauge gauge;
        Cache<?, ?> cache = MicroProfileSessionMetricUpdater.getPreparedStatementCache(context);
        if (cache == null) {
            LOG.warn("[{}] Metric {} is enabled in the config, but it looks like no CQL prepare processor is registered. The gauge will always return 0", (Object)context.getSessionName(), (Object)DefaultSessionMetric.CQL_PREPARED_CACHE_SIZE.getPath());
            gauge = () -> 0L;
        } else {
            gauge = () -> cache.size();
        }
        return gauge;
    }

    @Override
    public String buildFullName(SessionMetric metric, String profileName) {
        return "cassandra." + this.metricNamePrefix + metric.getPath();
    }

    private Gauge<Integer> buildQueueGauge(RequestThrottler requestThrottler, String logPrefix) {
        if (requestThrottler instanceof ConcurrencyLimitingRequestThrottler) {
            return () -> ((ConcurrencyLimitingRequestThrottler)((ConcurrencyLimitingRequestThrottler)requestThrottler)).getQueueSize();
        }
        if (requestThrottler instanceof RateLimitingRequestThrottler) {
            return () -> ((RateLimitingRequestThrottler)((RateLimitingRequestThrottler)requestThrottler)).getQueueSize();
        }
        LOG.warn("[{}] Metric {} does not support {}, it will always return 0", new Object[]{logPrefix, DefaultSessionMetric.THROTTLING_QUEUE_SIZE.getPath(), requestThrottler.getClass().getName()});
        return () -> 0;
    }

    @Nullable
    private static Cache<?, ?> getPreparedStatementCache(InternalDriverContext context) {
        for (RequestProcessor processor : context.getRequestProcessorRegistry().getProcessors()) {
            if (processor instanceof CqlPrepareAsyncProcessor) {
                return ((CqlPrepareAsyncProcessor)processor).getCache();
            }
            if (!(processor instanceof CqlPrepareSyncProcessor)) continue;
            return ((CqlPrepareSyncProcessor)processor).getCache();
        }
        return null;
    }
}

