/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.quarkus;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.auth.PlainTextAuthProvider;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.quarkus.runtime.api.config.CassandraClientConfig;
import com.datastax.oss.quarkus.runtime.api.session.QuarkusCqlSession;
import com.datastax.oss.quarkus.runtime.internal.metrics.MetricsConfig;
import com.datastax.oss.quarkus.runtime.internal.session.QuarkusCqlSessionBuilder;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.channel.EventLoopGroup;
import io.quarkus.arc.Unremovable;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.eclipse.microprofile.metrics.MetricRegistry;

@ApplicationScoped
public class CassandraClientProducer {
    private CassandraClientConfig config;
    private MetricsConfig metricsConfig;
    private MetricRegistry metricRegistry;
    private String protocolCompression;
    private EventLoopGroup mainEventLoop;

    @Produces
    @ApplicationScoped
    @Unremovable
    public QuarkusCqlSession createCassandraClient() {
        ProgrammaticDriverConfigLoaderBuilder configLoaderBuilder = this.createDriverConfigLoaderBuilder();
        this.configureRuntimeSettings(configLoaderBuilder);
        this.configureMetricsSettings(configLoaderBuilder);
        this.configureProtocolCompression(configLoaderBuilder);
        QuarkusCqlSessionBuilder builder = (QuarkusCqlSessionBuilder)new QuarkusCqlSessionBuilder().withMetricRegistry(this.metricRegistry).withQuarkusEventLoop(this.mainEventLoop).withConfigLoader(configLoaderBuilder.build());
        return (QuarkusCqlSession)builder.build();
    }

    public void setCassandraClientConfig(CassandraClientConfig config) {
        this.config = config;
    }

    public void setMetricsConfig(MetricsConfig metricsConfig) {
        this.metricsConfig = metricsConfig;
    }

    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public void setProtocolCompression(String protocolCompression) {
        this.protocolCompression = protocolCompression;
    }

    public void setMainEventLoop(EventLoopGroup mainEventLoop) {
        this.mainEventLoop = mainEventLoop;
    }

    private ProgrammaticDriverConfigLoaderBuilder createDriverConfigLoaderBuilder() {
        return new DefaultProgrammaticDriverConfigLoaderBuilder(() -> ConfigFactory.parseResources((String)"application.conf").withFallback((ConfigMergeable)ConfigFactory.parseResources((String)"application.json")).withFallback((ConfigMergeable)ConfigFactory.defaultReference((ClassLoader)CqlSession.class.getClassLoader())), "datastax-java-driver"){

            @NonNull
            public DriverConfigLoader build() {
                return new NonReloadableDriverConfigLoader(super.build());
            }
        };
    }

    public CassandraClientConfig getCassandraClientConfig() {
        return this.config;
    }

    public MetricsConfig getMetricsConfig() {
        return this.metricsConfig;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public String getProtocolCompression() {
        return this.protocolCompression;
    }

    public EventLoopGroup getMainEventLoop() {
        return this.mainEventLoop;
    }

    private void configureProtocolCompression(ProgrammaticDriverConfigLoaderBuilder configLoaderBuilder) {
        configLoaderBuilder.withString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, this.protocolCompression);
    }

    private void configureMetricsSettings(ProgrammaticDriverConfigLoaderBuilder configLoaderBuilder) {
        configLoaderBuilder.withStringList((DriverOption)DefaultDriverOption.METRICS_NODE_ENABLED, this.metricsConfig.metricsNodeEnabled);
        configLoaderBuilder.withStringList((DriverOption)DefaultDriverOption.METRICS_SESSION_ENABLED, this.metricsConfig.metricsSessionEnabled);
    }

    private void configureRuntimeSettings(ProgrammaticDriverConfigLoaderBuilder configLoaderBuilder) {
        this.config.cassandraClientConnectionConfig.contactPoints.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withStringList((DriverOption)DefaultDriverOption.CONTACT_POINTS, v);
        });
        this.config.cassandraClientConnectionConfig.localDatacenter.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, v);
        });
        this.config.cassandraClientConnectionConfig.keyspace.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DefaultDriverOption.SESSION_KEYSPACE, v);
        });
        this.config.cassandraClientCloudConfig.secureConnectBundle.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DefaultDriverOption.CLOUD_SECURE_CONNECT_BUNDLE, v.toAbsolutePath().toString());
        });
        configLoaderBuilder.withBoolean((DriverOption)DefaultDriverOption.RESOLVE_CONTACT_POINTS, this.config.cassandraClientInitConfig.resolveContactPoints);
        configLoaderBuilder.withBoolean((DriverOption)DefaultDriverOption.RECONNECT_ON_INIT, this.config.cassandraClientInitConfig.reconnectOnInit);
        this.config.cassandraClientRequestConfig.requestTimeout.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, v);
        });
        this.config.cassandraClientRequestConfig.consistencyLevel.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, v);
        });
        this.config.cassandraClientRequestConfig.serialConsistencyLevel.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY, v);
        });
        this.config.cassandraClientRequestConfig.pageSize.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE, v);
        });
        this.config.cassandraClientRequestConfig.defaultIdempotence.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withBoolean((DriverOption)DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE, v.booleanValue());
        });
        if (this.config.cassandraClientAuthConfig.username.isPresent() && this.config.cassandraClientAuthConfig.password.isPresent()) {
            ((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withClass((DriverOption)DefaultDriverOption.AUTH_PROVIDER_CLASS, PlainTextAuthProvider.class)).withString((DriverOption)DefaultDriverOption.AUTH_PROVIDER_USER_NAME, this.config.cassandraClientAuthConfig.username.get())).withString((DriverOption)DefaultDriverOption.AUTH_PROVIDER_PASSWORD, this.config.cassandraClientAuthConfig.password.get());
        }
        this.config.cassandraClientGraphConfig.graphName.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DseDriverOption.GRAPH_NAME, v);
        });
        this.config.cassandraClientGraphConfig.graphReadConsistencyLevel.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DseDriverOption.GRAPH_READ_CONSISTENCY_LEVEL, v);
        });
        this.config.cassandraClientGraphConfig.graphWriteConsistencyLevel.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DseDriverOption.GRAPH_WRITE_CONSISTENCY_LEVEL, v);
        });
        this.config.cassandraClientGraphConfig.graphRequestTimeout.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withDuration((DriverOption)DseDriverOption.GRAPH_TIMEOUT, v);
        });
    }

    private static class NonReloadableDriverConfigLoader
    implements DriverConfigLoader {
        private final DriverConfigLoader delegate;

        public NonReloadableDriverConfigLoader(DriverConfigLoader delegate) {
            this.delegate = delegate;
        }

        @NonNull
        public DriverConfig getInitialConfig() {
            return this.delegate.getInitialConfig();
        }

        public void onDriverInit(@NonNull DriverContext context) {
            this.delegate.onDriverInit(context);
        }

        @NonNull
        public CompletionStage<Boolean> reload() {
            return CompletableFutures.failedFuture((Throwable)new UnsupportedOperationException("reload not supported"));
        }

        public boolean supportsReloading() {
            return false;
        }

        public void close() {
            this.delegate.close();
        }
    }
}

