/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.quarkus;

import com.datastax.oss.quarkus.runtime.api.config.CassandraClientConfig;
import com.datastax.oss.quarkus.runtime.api.session.QuarkusCqlSession;
import com.datastax.oss.quarkus.runtime.internal.metrics.MetricsConfig;
import com.datastax.oss.quarkus.runtime.internal.metrics.NoopMetricRegistry;
import com.datastax.oss.quarkus.runtime.internal.quarkus.CassandraClientProducer;
import io.netty.channel.EventLoopGroup;
import io.quarkus.arc.Arc;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.netty.MainEventLoopGroup;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.metrics.MetricRegistries;
import java.lang.annotation.Annotation;
import javax.enterprise.util.AnnotationLiteral;
import org.eclipse.microprofile.metrics.MetricRegistry;

@Recorder
public class CassandraClientRecorder {
    public void configureRuntimeProperties(CassandraClientConfig config) {
        CassandraClientProducer producer = this.getProducerInstance();
        producer.setCassandraClientConfig(config);
    }

    public RuntimeValue<QuarkusCqlSession> buildClient(ShutdownContext shutdown, BeanContainer beanContainer) {
        QuarkusCqlSession cqlSession = (QuarkusCqlSession)beanContainer.instance(QuarkusCqlSession.class, new Annotation[0]);
        shutdown.addShutdownTask(() -> ((QuarkusCqlSession)cqlSession).close());
        return new RuntimeValue((Object)cqlSession);
    }

    public void configureMetrics(MetricsConfig metricsConfig) {
        CassandraClientProducer producer = this.getProducerInstance();
        producer.setMetricsConfig(metricsConfig);
    }

    public void setInjectedMetricRegistry() {
        CassandraClientProducer producer = this.getProducerInstance();
        MetricRegistry metricRegistry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR);
        producer.setMetricRegistry(metricRegistry);
    }

    public void setNoopMetricRegistry() {
        CassandraClientProducer producer = this.getProducerInstance();
        producer.setMetricRegistry(new NoopMetricRegistry());
    }

    public void configureCompression(String protocolCompression) {
        CassandraClientProducer producer = this.getProducerInstance();
        producer.setProtocolCompression(protocolCompression);
    }

    public void setInjectedNettyEventLoop(boolean useQuarkusNettyEventLoop) {
        CassandraClientProducer producer = this.getProducerInstance();
        if (useQuarkusNettyEventLoop) {
            EventLoopGroup mainEventLoop = (EventLoopGroup)Arc.container().instance(EventLoopGroup.class, new Annotation[]{new AnnotationLiteral<MainEventLoopGroup>(){}}).get();
            producer.setMainEventLoop(mainEventLoop);
        }
    }

    private CassandraClientProducer getProducerInstance() {
        return (CassandraClientProducer)Arc.container().instance(CassandraClientProducer.class, new Annotation[0]).get();
    }
}

