/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.reactive;

import com.datastax.dse.driver.api.mapper.reactive.MappedReactiveResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.quarkus.runtime.api.reactive.mapper.MutinyMappedReactiveResultSet;
import com.datastax.oss.quarkus.runtime.internal.reactive.Wrappers;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiBroadcast;
import io.smallrye.mutiny.groups.MultiCollect;
import io.smallrye.mutiny.groups.MultiConvert;
import io.smallrye.mutiny.groups.MultiGroup;
import io.smallrye.mutiny.groups.MultiOnCompletion;
import io.smallrye.mutiny.groups.MultiOnEvent;
import io.smallrye.mutiny.groups.MultiOnFailure;
import io.smallrye.mutiny.groups.MultiOnItem;
import io.smallrye.mutiny.groups.MultiOverflow;
import io.smallrye.mutiny.groups.MultiSubscribe;
import io.smallrye.mutiny.groups.MultiTransform;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Subscriber;

public class DefaultMutinyMappedReactiveResultSet<EntityT>
implements MutinyMappedReactiveResultSet<EntityT> {
    private final Multi<EntityT> multi;
    private final Multi<ExecutionInfo> executionInfos;
    private final Multi<ColumnDefinitions> columnDefinitions;
    private final Multi<Boolean> wasApplied;

    public DefaultMutinyMappedReactiveResultSet(MappedReactiveResultSet<EntityT> resultSet) {
        this.multi = Wrappers.toMulti(resultSet);
        Multi columnDefinitions = Wrappers.toMulti(resultSet.getColumnDefinitions());
        this.columnDefinitions = columnDefinitions;
        Multi executionInfos = Wrappers.toMulti(resultSet.getExecutionInfos());
        this.executionInfos = executionInfos;
        this.wasApplied = Wrappers.toMulti(resultSet.wasApplied());
    }

    @NonNull
    public Multi<ColumnDefinitions> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    @NonNull
    public Multi<ExecutionInfo> getExecutionInfos() {
        return this.executionInfos;
    }

    @NonNull
    public Multi<Boolean> wasApplied() {
        return this.wasApplied;
    }

    public MultiSubscribe<EntityT> subscribe() {
        return this.multi.subscribe();
    }

    public MultiOnItem<EntityT> onItem() {
        return this.multi.onItem();
    }

    public <O> O then(Function<Multi<EntityT>, O> stage) {
        return (O)this.multi.then(stage);
    }

    public Uni<EntityT> toUni() {
        return this.multi.toUni();
    }

    public MultiOnFailure<EntityT> onFailure() {
        return this.multi.onFailure();
    }

    public MultiOnFailure<EntityT> onFailure(Predicate<? super Throwable> predicate) {
        return this.multi.onFailure(predicate);
    }

    public MultiOnFailure<EntityT> onFailure(Class<? extends Throwable> aClass) {
        return this.multi.onFailure(aClass);
    }

    public MultiOnEvent<EntityT> on() {
        return this.multi.on();
    }

    public Multi<EntityT> cache() {
        return this.multi.cache();
    }

    public MultiCollect<EntityT> collectItems() {
        return this.multi.collectItems();
    }

    public MultiGroup<EntityT> groupItems() {
        return this.multi.groupItems();
    }

    public Multi<EntityT> emitOn(Executor executor) {
        return this.multi.emitOn(executor);
    }

    public Multi<EntityT> runSubscriptionOn(Executor executor) {
        return this.multi.runSubscriptionOn(executor);
    }

    public MultiOnCompletion<EntityT> onCompletion() {
        return this.multi.onCompletion();
    }

    public MultiTransform<EntityT> transform() {
        return this.multi.transform();
    }

    public MultiOverflow<EntityT> onOverflow() {
        return this.multi.onOverflow();
    }

    public MultiBroadcast<EntityT> broadcast() {
        return this.multi.broadcast();
    }

    public MultiConvert<EntityT> convert() {
        return this.multi.convert();
    }

    public void subscribe(Subscriber<? super EntityT> subscriber) {
        this.multi.subscribe(subscriber);
    }
}

