/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.reactive;

import com.datastax.dse.driver.api.core.cql.reactive.ReactiveResultSet;
import com.datastax.dse.driver.api.core.cql.reactive.ReactiveRow;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.quarkus.runtime.api.reactive.MutinyContinuousReactiveResultSet;
import com.datastax.oss.quarkus.runtime.api.reactive.MutinyReactiveResultSet;
import com.datastax.oss.quarkus.runtime.internal.reactive.Wrappers;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiBroadcast;
import io.smallrye.mutiny.groups.MultiCollect;
import io.smallrye.mutiny.groups.MultiConvert;
import io.smallrye.mutiny.groups.MultiGroup;
import io.smallrye.mutiny.groups.MultiOnCompletion;
import io.smallrye.mutiny.groups.MultiOnEvent;
import io.smallrye.mutiny.groups.MultiOnFailure;
import io.smallrye.mutiny.groups.MultiOnItem;
import io.smallrye.mutiny.groups.MultiOverflow;
import io.smallrye.mutiny.groups.MultiSubscribe;
import io.smallrye.mutiny.groups.MultiTransform;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Subscriber;

public class DefaultMutinyReactiveResultSet
implements MutinyReactiveResultSet,
MutinyContinuousReactiveResultSet {
    private final Multi<ReactiveRow> multi;
    private final Multi<ColumnDefinitions> columnDefinitions;
    private final Multi<ExecutionInfo> executionInfos;
    private final Multi<Boolean> wasApplied;

    public DefaultMutinyReactiveResultSet(ReactiveResultSet reactiveResultSet) {
        this.multi = Wrappers.toMulti(reactiveResultSet);
        Multi columnDefinitions = Wrappers.toMulti(reactiveResultSet.getColumnDefinitions());
        this.columnDefinitions = columnDefinitions;
        Multi executionInfos = Wrappers.toMulti(reactiveResultSet.getExecutionInfos());
        this.executionInfos = executionInfos;
        this.wasApplied = Wrappers.toMulti(reactiveResultSet.wasApplied());
    }

    @Override
    @NonNull
    public Multi<ColumnDefinitions> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    @Override
    @NonNull
    public Multi<ExecutionInfo> getExecutionInfos() {
        return this.executionInfos;
    }

    @Override
    @NonNull
    public Multi<Boolean> wasApplied() {
        return this.wasApplied;
    }

    public MultiSubscribe<ReactiveRow> subscribe() {
        return this.multi.subscribe();
    }

    public MultiOnItem<ReactiveRow> onItem() {
        return this.multi.onItem();
    }

    public <O> O then(Function<Multi<ReactiveRow>, O> stage) {
        return (O)this.multi.then(stage);
    }

    public Uni<ReactiveRow> toUni() {
        return this.multi.toUni();
    }

    public MultiOnFailure<ReactiveRow> onFailure() {
        return this.multi.onFailure();
    }

    public MultiOnFailure<ReactiveRow> onFailure(Predicate<? super Throwable> predicate) {
        return this.multi.onFailure(predicate);
    }

    public MultiOnFailure<ReactiveRow> onFailure(Class<? extends Throwable> aClass) {
        return this.multi.onFailure(aClass);
    }

    public MultiOnEvent<ReactiveRow> on() {
        return this.multi.on();
    }

    public Multi<ReactiveRow> cache() {
        return this.multi.cache();
    }

    public MultiCollect<ReactiveRow> collectItems() {
        return this.multi.collectItems();
    }

    public MultiGroup<ReactiveRow> groupItems() {
        return this.multi.groupItems();
    }

    public Multi<ReactiveRow> emitOn(Executor executor) {
        return this.multi.emitOn(executor);
    }

    public Multi<ReactiveRow> runSubscriptionOn(Executor executor) {
        return this.multi.runSubscriptionOn(executor);
    }

    public MultiOnCompletion<ReactiveRow> onCompletion() {
        return this.multi.onCompletion();
    }

    public MultiTransform<ReactiveRow> transform() {
        return this.multi.transform();
    }

    public MultiOverflow<ReactiveRow> onOverflow() {
        return this.multi.onOverflow();
    }

    public MultiBroadcast<ReactiveRow> broadcast() {
        return this.multi.broadcast();
    }

    public MultiConvert<ReactiveRow> convert() {
        return this.multi.convert();
    }

    public void subscribe(Subscriber<? super ReactiveRow> subscriber) {
        this.multi.subscribe(subscriber);
    }
}

