/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.reactive;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.concurrent.Executor;
import org.reactivestreams.Publisher;

public class Wrappers {
    public static <T> Multi<T> toMulti(Publisher<T> source) {
        Multi multi = Multi.createFrom().publisher(source);
        Context context = Vertx.currentContext();
        if (context != null) {
            multi = multi.emitOn((Executor)new VertexContextExecutor(context));
        }
        return multi;
    }

    public static <T> Uni<T> toUni(Publisher<T> source) {
        Context context = Vertx.currentContext();
        Uni uni = Uni.createFrom().publisher(source);
        if (context != null) {
            uni = uni.emitOn((Executor)new VertexContextExecutor(context));
        }
        return uni;
    }

    public static <T> Uni<T> failedUni(Throwable error) {
        return Uni.createFrom().failure(error);
    }

    private static class VertexContextExecutor
    implements Executor {
        private final Context context;

        public VertexContextExecutor(Context context) {
            this.context = context;
        }

        @Override
        public void execute(@NonNull Runnable command) {
            this.context.runOnContext(x -> command.run());
        }
    }
}

