/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.health;

import com.datastax.oss.driver.api.core.AsyncPagingIterable;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.quarkus.runtime.api.session.QuarkusCqlSession;
import com.datastax.oss.quarkus.runtime.internal.quarkus.CassandraClientRecorder;
import io.quarkus.arc.Arc;
import io.smallrye.health.api.AsyncHealthCheck;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class CassandraAsyncHealthCheck
implements AsyncHealthCheck {
    private static final String HEALTH_CHECK_NAME = "DataStax Apache Cassandra Driver health check";
    static final String HEALTH_CHECK_QUERY = "SELECT data_center, release_version, cluster_name, cql_version FROM system.local";
    private CompletionStage<QuarkusCqlSession> cqlSessionCompletionStage;

    public CompletionStage<QuarkusCqlSession> sessionBean() {
        return (CompletionStage)Arc.container().instance(CassandraClientRecorder.SESSION_STAGE, new Annotation[0]).get();
    }

    @PostConstruct
    protected void init() {
        this.cqlSessionCompletionStage = this.sessionBean();
    }

    public Uni<HealthCheckResponse> call() {
        return Uni.createFrom().completionStage(this.cqlSessionCompletionStage.thenCompose(cqlSession -> cqlSession.executeAsync(HEALTH_CHECK_QUERY).thenApply(AsyncPagingIterable::one).thenApply(result -> {
            HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)HEALTH_CHECK_NAME).up();
            if (result == null) {
                return builder.down().withData("reason", "system.local returned null").build();
            }
            for (Map.Entry<String, String> entry : this.extractInfoFromResult((Row)result).entrySet()) {
                builder.withData(entry.getKey(), entry.getValue());
            }
            return builder.withData("numberOfNodes", (long)cqlSession.getMetadata().getNodes().size()).up().build();
        }).exceptionally(ex -> {
            HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)HEALTH_CHECK_NAME).up();
            return builder.down().withData("reason", ex.getMessage()).build();
        })));
    }

    private Map<String, String> extractInfoFromResult(Row result) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("datacenter", result.getString("data_center"));
        details.put("releaseVersion", result.getString("release_version"));
        details.put("clusterName", result.getString("cluster_name"));
        details.put("cqlVersion", result.getString("cql_version"));
        return details;
    }
}

