/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.quarkus;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.auth.PlainTextAuthProvider;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.internal.core.metrics.TaggingMetricIdGenerator;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.quarkus.runtime.api.config.CassandraClientConfig;
import com.datastax.oss.quarkus.runtime.api.session.QuarkusCqlSession;
import com.datastax.oss.quarkus.runtime.internal.session.QuarkusCqlSessionBuilder;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.channel.EventLoopGroup;
import io.quarkus.arc.Unremovable;
import io.quarkus.netty.MainEventLoopGroup;
import io.smallrye.mutiny.Uni;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CassandraClientProducer {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraClientProducer.class);
    private final AtomicBoolean produced = new AtomicBoolean(false);
    private String protocolCompression;
    private Object metricRegistry;
    private String metricsFactoryClass;

    @Produces
    @ApplicationScoped
    @Unremovable
    public CompletionStage<QuarkusCqlSession> produceQuarkusCqlSessionStage(CassandraClientConfig config, @MainEventLoopGroup EventLoopGroup mainEventLoop) {
        LOG.debug("Producing CompletionStage<QuarkusCqlSession> bean, metricRegistry = {}, useQuarkusEventLoop = {}", this.metricRegistry, (Object)config.cassandraClientInitConfig.useQuarkusEventLoop);
        ProgrammaticDriverConfigLoaderBuilder configLoaderBuilder = this.createDriverConfigLoaderBuilder();
        this.configureRuntimeSettings(configLoaderBuilder, config);
        this.configureMetricsSettings(configLoaderBuilder, config);
        this.configureProtocolCompression(configLoaderBuilder);
        QuarkusCqlSessionBuilder builder = (QuarkusCqlSessionBuilder)new QuarkusCqlSessionBuilder().withConfigLoader(configLoaderBuilder.build());
        if (this.metricRegistry != null) {
            LOG.debug("Metric registry = {}", this.metricRegistry);
            builder.withMetricRegistry(this.metricRegistry);
        }
        if (config.cassandraClientInitConfig.useQuarkusEventLoop) {
            builder.withQuarkusEventLoop(mainEventLoop);
        }
        CompletionStage sessionFuture = builder.buildAsync();
        this.produced.set(true);
        return sessionFuture;
    }

    @Produces
    @ApplicationScoped
    @Unremovable
    public QuarkusCqlSession produceQuarkusCqlSession(CompletionStage<QuarkusCqlSession> sessionFuture, CassandraClientConfig config) throws ExecutionException, InterruptedException {
        LOG.debug("Producing QuarkusCqlSession bean, eagerSessionInit = {}", (Object)config.cassandraClientInitConfig.eagerInit);
        if (!config.cassandraClientInitConfig.eagerInit && config.cassandraClientInitConfig.printEagerInitInfo) {
            LOG.info("Injecting QuarkusCqlSession and setting quarkus.cassandra.init.eager-init = false may cause problems if the lazy initialization process happens on a thread that is not allowed to block, such as Vert.x thread.");
            LOG.info("Please either set quarkus.cassandra.init.eager-init = true, or inject CompletionStage<QuarkusCqlSession> instead, or make sure that the lazy initialization process  is not happening on a Vert.x thread.");
            LOG.info("Set the config property quarkus.cassandra.init.print-eager-init-info = false to suppress this message.");
        }
        return sessionFuture.toCompletableFuture().get();
    }

    @Produces
    @ApplicationScoped
    @Unremovable
    public Uni<QuarkusCqlSession> produceQuarkusCqlSessionUni(CompletionStage<QuarkusCqlSession> sessionFuture) {
        LOG.debug("Producing Uni<QuarkusCqlSession>");
        return Uni.createFrom().completionStage(sessionFuture);
    }

    public void setMetricsFactoryClassName(String metricsFactoryClass) {
        this.metricsFactoryClass = metricsFactoryClass;
    }

    public void setMetricRegistry(Object metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public void setProtocolCompression(String protocolCompression) {
        this.protocolCompression = protocolCompression;
    }

    private ProgrammaticDriverConfigLoaderBuilder createDriverConfigLoaderBuilder() {
        return new DefaultProgrammaticDriverConfigLoaderBuilder(() -> ConfigFactory.parseResources((String)"application.conf").withFallback((ConfigMergeable)ConfigFactory.parseResources((String)"application.json")).withFallback((ConfigMergeable)ConfigFactory.defaultReference((ClassLoader)CqlSession.class.getClassLoader())), "datastax-java-driver"){

            @NonNull
            public DriverConfigLoader build() {
                return new NonReloadableDriverConfigLoader(super.build());
            }
        };
    }

    private void configureProtocolCompression(ProgrammaticDriverConfigLoaderBuilder configLoaderBuilder) {
        configLoaderBuilder.withString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, this.protocolCompression);
    }

    private void configureMetricsSettings(ProgrammaticDriverConfigLoaderBuilder configLoaderBuilder, CassandraClientConfig config) {
        List<String> enabledSessionMetrics;
        List<String> enabledNodeMetrics;
        if (this.metricRegistry != null && this.metricsFactoryClass != null && this.checkMetricsPresent(enabledNodeMetrics = config.cassandraClientMetricsConfig.enabledNodeMetrics.orElse(Collections.emptyList()), enabledSessionMetrics = config.cassandraClientMetricsConfig.enabledSessionMetrics.orElse(Collections.emptyList()))) {
            configLoaderBuilder.withString((DriverOption)DefaultDriverOption.METRICS_FACTORY_CLASS, this.metricsFactoryClass);
            configLoaderBuilder.withString((DriverOption)DefaultDriverOption.METRICS_ID_GENERATOR_CLASS, TaggingMetricIdGenerator.class.getName());
            configLoaderBuilder.withString((DriverOption)DefaultDriverOption.METRICS_ID_GENERATOR_PREFIX, config.cassandraClientMetricsConfig.prefix);
            configLoaderBuilder.withStringList((DriverOption)DefaultDriverOption.METRICS_NODE_ENABLED, enabledNodeMetrics);
            configLoaderBuilder.withStringList((DriverOption)DefaultDriverOption.METRICS_SESSION_ENABLED, enabledSessionMetrics);
        }
    }

    private boolean checkMetricsPresent(List<String> enabledNodeMetrics, List<String> enabledSessionMetrics) {
        if (enabledNodeMetrics.isEmpty() && enabledSessionMetrics.isEmpty()) {
            LOG.warn("Metrics were enabled in the configuration, but no session-level or node-level metrics were enabled; forcibly disabling metrics. Make to sure enable at least one metric to track using the cassandra.metrics.session.enabled or cassandra.metrics.node.enabled properties.");
            return false;
        }
        return true;
    }

    private void configureRuntimeSettings(ProgrammaticDriverConfigLoaderBuilder configLoaderBuilder, CassandraClientConfig config) {
        config.cassandraClientConnectionConfig.contactPoints.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withStringList((DriverOption)DefaultDriverOption.CONTACT_POINTS, v);
        });
        config.cassandraClientConnectionConfig.localDatacenter.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, v);
        });
        config.cassandraClientConnectionConfig.keyspace.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DefaultDriverOption.SESSION_KEYSPACE, v);
        });
        config.cassandraClientCloudConfig.secureConnectBundle.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DefaultDriverOption.CLOUD_SECURE_CONNECT_BUNDLE, v.toAbsolutePath().toString());
        });
        configLoaderBuilder.withBoolean((DriverOption)DefaultDriverOption.RESOLVE_CONTACT_POINTS, config.cassandraClientInitConfig.resolveContactPoints);
        configLoaderBuilder.withBoolean((DriverOption)DefaultDriverOption.RECONNECT_ON_INIT, config.cassandraClientInitConfig.reconnectOnInit);
        config.cassandraClientRequestConfig.requestTimeout.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, v);
        });
        config.cassandraClientRequestConfig.consistencyLevel.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, v);
        });
        config.cassandraClientRequestConfig.serialConsistencyLevel.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY, v);
        });
        config.cassandraClientRequestConfig.pageSize.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE, v);
        });
        config.cassandraClientRequestConfig.defaultIdempotence.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withBoolean((DriverOption)DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE, v.booleanValue());
        });
        if (config.cassandraClientAuthConfig.username.isPresent() && config.cassandraClientAuthConfig.password.isPresent()) {
            ((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withClass((DriverOption)DefaultDriverOption.AUTH_PROVIDER_CLASS, PlainTextAuthProvider.class)).withString((DriverOption)DefaultDriverOption.AUTH_PROVIDER_USER_NAME, config.cassandraClientAuthConfig.username.get())).withString((DriverOption)DefaultDriverOption.AUTH_PROVIDER_PASSWORD, config.cassandraClientAuthConfig.password.get());
        }
        config.cassandraClientGraphConfig.graphName.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DseDriverOption.GRAPH_NAME, v);
        });
        config.cassandraClientGraphConfig.graphReadConsistencyLevel.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DseDriverOption.GRAPH_READ_CONSISTENCY_LEVEL, v);
        });
        config.cassandraClientGraphConfig.graphWriteConsistencyLevel.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withString((DriverOption)DseDriverOption.GRAPH_WRITE_CONSISTENCY_LEVEL, v);
        });
        config.cassandraClientGraphConfig.graphRequestTimeout.ifPresent(v -> {
            ProgrammaticDriverConfigLoaderBuilder cfr_ignored_0 = (ProgrammaticDriverConfigLoaderBuilder)configLoaderBuilder.withDuration((DriverOption)DseDriverOption.GRAPH_TIMEOUT, v);
        });
    }

    public boolean isProduced() {
        return this.produced.get();
    }

    private static class NonReloadableDriverConfigLoader
    implements DriverConfigLoader {
        private final DriverConfigLoader delegate;

        public NonReloadableDriverConfigLoader(DriverConfigLoader delegate) {
            this.delegate = delegate;
        }

        @NonNull
        public DriverConfig getInitialConfig() {
            return this.delegate.getInitialConfig();
        }

        public void onDriverInit(@NonNull DriverContext context) {
            this.delegate.onDriverInit(context);
        }

        @NonNull
        public CompletionStage<Boolean> reload() {
            return CompletableFutures.failedFuture((Throwable)new UnsupportedOperationException("reload not supported"));
        }

        public boolean supportsReloading() {
            return false;
        }

        public void close() {
            this.delegate.close();
        }
    }
}

