/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.quarkus;

import com.datastax.oss.quarkus.runtime.api.session.QuarkusCqlSession;
import com.datastax.oss.quarkus.runtime.internal.quarkus.CassandraClientProducer;
import io.quarkus.arc.Arc;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.util.TypeLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Recorder
public class CassandraClientRecorder {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraClientRecorder.class);
    public static final TypeLiteral<CompletionStage<QuarkusCqlSession>> SESSION_STAGE = new TypeLiteral<CompletionStage<QuarkusCqlSession>>(){};

    public RuntimeValue<CompletionStage<QuarkusCqlSession>> buildClient(ShutdownContext shutdown) {
        LOG.debug("CassandraClientRecorder.buildClient");
        CompletionStage sessionStage = (CompletionStage)Arc.container().instance(SESSION_STAGE, new Annotation[0]).get();
        shutdown.addShutdownTask(() -> {
            CassandraClientProducer cassandraClientProducer = (CassandraClientProducer)Arc.container().instance(CassandraClientProducer.class, new Annotation[0]).get();
            if (cassandraClientProducer != null) {
                LOG.debug("Executing shutdown hook, session stage bean produced = {}", (Object)cassandraClientProducer.isProduced());
                if (cassandraClientProducer.isProduced()) {
                    CompletableFuture sessionFuture = sessionStage.toCompletableFuture();
                    LOG.debug("Session future done = {}, cancelled = {}", (Object)sessionFuture.isDone(), (Object)sessionFuture.isCancelled());
                    try {
                        QuarkusCqlSession session = sessionFuture.getNow(null);
                        LOG.debug("Session object = {}", (Object)session);
                        if (session != null) {
                            LOG.info("Closing Quarkus Cassandra session.");
                            session.close();
                        } else {
                            LOG.info("Cancelling Quarkus Cassandra session initialization.");
                            sessionFuture.cancel(true);
                        }
                    }
                    catch (RuntimeException e) {
                        LOG.trace("Quarkus Cassandra session could not be closed normally.", (Throwable)e);
                    }
                }
            }
        });
        return new RuntimeValue((Object)sessionStage);
    }

    public void configureMicrometerMetrics() {
        LOG.info("Enabling Cassandra metrics using Micrometer.");
        try {
            Class<?> meterRegistryClass = Class.forName("io.micrometer.core.instrument.MeterRegistry");
            Object meterRegistry = Arc.container().instance(meterRegistryClass, new Annotation[0]).get();
            CassandraClientProducer producer = this.getProducerInstance();
            producer.setMetricRegistry(meterRegistry);
            producer.setMetricsFactoryClassName("com.datastax.oss.driver.internal.metrics.micrometer.MicrometerMetricsFactory");
        }
        catch (Exception e) {
            LOG.error("Failed to enable Cassandra metrics using Micrometer", (Throwable)e);
        }
    }

    public void configureMicroProfileMetrics() {
        LOG.info("Enabling Cassandra metrics using MicroProfile.");
        try {
            Object metricRegistry = this.locateMicroProfileVendorMetricRegistry();
            CassandraClientProducer producer = this.getProducerInstance();
            producer.setMetricRegistry(metricRegistry);
            producer.setMetricsFactoryClassName("com.datastax.oss.driver.internal.metrics.microprofile.MicroProfileMetricsFactory");
        }
        catch (Exception e) {
            LOG.error("Failed to enable Cassandra metrics using MicroProfile", (Throwable)e);
        }
    }

    private Object locateMicroProfileVendorMetricRegistry() throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> metricRegistriesClass = Class.forName("io.smallrye.metrics.MetricRegistries");
        Object metricRegistries = Arc.container().instance(metricRegistriesClass, new Annotation[0]).get();
        return metricRegistriesClass.getMethod("getVendorRegistry", new Class[0]).invoke(metricRegistries, new Object[0]);
    }

    public void configureCompression(String protocolCompression) {
        LOG.debug("Configuring protocol compression {}", (Object)protocolCompression);
        CassandraClientProducer producer = this.getProducerInstance();
        producer.setProtocolCompression(protocolCompression);
    }

    private CassandraClientProducer getProducerInstance() {
        return (CassandraClientProducer)Arc.container().instance(CassandraClientProducer.class, new Annotation[0]).get();
    }
}

