/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.reactive;

import com.datastax.dse.driver.api.core.cql.reactive.ReactiveResultSet;
import com.datastax.dse.driver.api.core.cql.reactive.ReactiveRow;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.quarkus.runtime.api.reactive.MutinyContinuousReactiveResultSet;
import com.datastax.oss.quarkus.runtime.api.reactive.MutinyReactiveResultSet;
import com.datastax.oss.quarkus.runtime.internal.reactive.Wrappers;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.MultiSubscriber;

public class DefaultMutinyReactiveResultSet
extends AbstractMulti<ReactiveRow>
implements MutinyReactiveResultSet,
MutinyContinuousReactiveResultSet {
    private final Multi<ReactiveRow> multi;
    private final Multi<ColumnDefinitions> columnDefinitions;
    private final Multi<ExecutionInfo> executionInfos;
    private final Multi<Boolean> wasApplied;

    public DefaultMutinyReactiveResultSet(ReactiveResultSet reactiveResultSet) {
        this.multi = Wrappers.toMulti(reactiveResultSet);
        Multi columnDefinitions = Wrappers.toMulti(reactiveResultSet.getColumnDefinitions());
        this.columnDefinitions = columnDefinitions;
        Multi executionInfos = Wrappers.toMulti(reactiveResultSet.getExecutionInfos());
        this.executionInfos = executionInfos;
        this.wasApplied = Wrappers.toMulti(reactiveResultSet.wasApplied());
    }

    @Override
    @NonNull
    public Multi<ColumnDefinitions> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    @Override
    @NonNull
    public Multi<ExecutionInfo> getExecutionInfos() {
        return this.executionInfos;
    }

    @Override
    @NonNull
    public Multi<Boolean> wasApplied() {
        return this.wasApplied;
    }

    public void subscribe(MultiSubscriber<? super ReactiveRow> subscriber) {
        this.multi.subscribe(Infrastructure.onMultiSubscription(this.multi, subscriber));
    }
}

