/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.quarkus;

import com.datastax.oss.quarkus.runtime.api.config.CassandraClientConfig;
import com.datastax.oss.quarkus.runtime.api.mapper.QuarkusGeneratedDaoBean;
import com.datastax.oss.quarkus.runtime.api.mapper.QuarkusGeneratedMapperBean;
import com.datastax.oss.quarkus.runtime.api.session.QuarkusCqlSession;
import io.quarkus.runtime.StartupEvent;
import io.smallrye.mutiny.TimeoutException;
import io.smallrye.mutiny.Uni;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class CassandraClientStarter {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraClientStarter.class);
    @Inject
    CassandraClientConfig config;
    @Inject
    Instance<CompletionStage<QuarkusCqlSession>> sessions;
    @Inject
    @QuarkusGeneratedMapperBean
    Instance<Object> mappers;
    @Inject
    @QuarkusGeneratedDaoBean
    Instance<Object> daos;
    private Duration timeout;

    public void onStartup(@Observes StartupEvent event) throws ExecutionException, InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CassandraClientStarter.startup, eager = {}, sessions = {}, mappers = {}, daos = {}", new Object[]{this.config.cassandraClientInitConfig.eagerInit, this.sessions.stream().count(), this.mappers.stream().count(), this.daos.stream().count()});
        }
        if (this.config.cassandraClientInitConfig.eagerInit) {
            LOG.info("Eagerly initializing Quarkus Cassandra client.");
            this.timeout = this.config.cassandraClientInitConfig.eagerInitTimeout;
            this.initializeBeans(this.sessions, "session");
            this.initializeBeans(this.mappers, "mapper");
            this.initializeBeans(this.daos, "DAO");
        } else {
            LOG.debug("Eager initialization of Quarkus Cassandra client at startup is disabled by configuration.");
        }
    }

    private void initializeBeans(Instance<?> beans, String beanName) throws InterruptedException, ExecutionException {
        for (Object bean : beans) {
            try {
                if (bean instanceof CompletionStage) {
                    ((CompletionStage)bean).toCompletableFuture().get(this.timeout.toNanos(), TimeUnit.NANOSECONDS);
                    continue;
                }
                if (!(bean instanceof Uni)) continue;
                ((Uni)bean).await().atMost(this.timeout);
            }
            catch (TimeoutException | java.util.concurrent.TimeoutException e) {
                LOG.warn("Eager initialization of a {} bean did not complete within {}; resuming application startup with uninitialized bean.", (Object)beanName, (Object)this.timeout);
            }
        }
    }
}

