/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.reactive;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.concurrent.Executor;
import org.reactivestreams.Publisher;

public class MutinyWrappers {
    public static <T> Multi<T> toMulti(Publisher<T> source) {
        Multi multi = Multi.createFrom().publisher(source);
        Context context = Vertx.currentContext();
        if (context != null) {
            multi = multi.emitOn((Executor)new VertxContextExecutor(context));
        }
        return multi;
    }

    public static <T> Uni<T> toUni(Publisher<T> source) {
        Uni uni = Uni.createFrom().publisher(source);
        Context context = Vertx.currentContext();
        if (context != null) {
            uni = uni.emitOn((Executor)new VertxContextExecutor(context));
        }
        return uni;
    }

    private static class VertxContextExecutor
    implements Executor {
        private final Context context;

        public VertxContextExecutor(Context context) {
            this.context = context;
        }

        @Override
        public void execute(@NonNull Runnable command) {
            this.context.runOnContext(x -> command.run());
        }
    }
}

