/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.reactive.mapper;

import com.datastax.dse.driver.api.mapper.reactive.MappedReactiveResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.quarkus.runtime.api.reactive.mapper.MutinyMappedReactiveResultSet;
import com.datastax.oss.quarkus.runtime.internal.reactive.MutinyWrappers;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.MultiSubscriber;

public class DefaultMutinyMappedReactiveResultSet<EntityT>
extends AbstractMulti<EntityT>
implements MutinyMappedReactiveResultSet<EntityT> {
    private final Multi<EntityT> multi;
    private final Multi<ExecutionInfo> executionInfos;
    private final Multi<ColumnDefinitions> columnDefinitions;
    private final Multi<Boolean> wasApplied;

    public DefaultMutinyMappedReactiveResultSet(MappedReactiveResultSet<EntityT> resultSet) {
        this.multi = MutinyWrappers.toMulti(resultSet);
        Multi columnDefinitions = MutinyWrappers.toMulti(resultSet.getColumnDefinitions());
        this.columnDefinitions = columnDefinitions;
        Multi executionInfos = MutinyWrappers.toMulti(resultSet.getExecutionInfos());
        this.executionInfos = executionInfos;
        this.wasApplied = MutinyWrappers.toMulti(resultSet.wasApplied());
    }

    @NonNull
    public Multi<ColumnDefinitions> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    @NonNull
    public Multi<ExecutionInfo> getExecutionInfos() {
        return this.executionInfos;
    }

    @NonNull
    public Multi<Boolean> wasApplied() {
        return this.wasApplied;
    }

    public void subscribe(MultiSubscriber<? super EntityT> subscriber) {
        this.multi.subscribe(Infrastructure.onMultiSubscription(this.multi, subscriber));
    }
}

