/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.reactive.mapper;

import com.datastax.dse.driver.api.core.cql.reactive.ReactiveResultSet;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.data.GettableByName;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.mapper.MapperException;
import com.datastax.oss.driver.api.mapper.entity.EntityHelper;
import com.datastax.oss.quarkus.runtime.internal.reactive.MutinyWrappers;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;

public class MapperMutinyWrappers {
    private static final CqlIdentifier APPLIED = CqlIdentifier.fromInternal((String)"[applied]");
    private static final MapperException NO_ROW = new MapperException("Expected the COUNT query to return exactly one row");
    private static final MapperException INVALID_ROW = new MapperException("Expected the COUNT query to return a column with CQL type BIGINT in first position");

    public static <EntityT> Uni<EntityT> toEntityUni(ReactiveResultSet source, EntityHelper<EntityT> entityHelper) {
        return MutinyWrappers.toUni(source).map(row -> MapperMutinyWrappers.extractEntity((Row)row, entityHelper));
    }

    public static Uni<Void> toVoidUni(ReactiveResultSet source) {
        return MutinyWrappers.toUni(source).map(ignored -> null);
    }

    public static Uni<Boolean> toWasAppliedUni(ReactiveResultSet source) {
        return MutinyWrappers.toUni(source).flatMap(ignored -> MutinyWrappers.toUni(source.wasApplied()));
    }

    public static Uni<Long> toCountUni(ReactiveResultSet source) {
        return MutinyWrappers.toUni(source).flatMap(MapperMutinyWrappers::extractCount);
    }

    public static Uni<Row> toRowUni(ReactiveResultSet source) {
        return MutinyWrappers.toUni(source).onItem().castTo(Row.class);
    }

    public static Multi<Row> toRowMulti(ReactiveResultSet source) {
        return MutinyWrappers.toMulti(source).onItem().castTo(Row.class);
    }

    public static <T> Uni<T> failedUni(Throwable error) {
        return Uni.createFrom().failure(error);
    }

    public static <T> Multi<T> failedMulti(Throwable error) {
        return Multi.createFrom().failure(error);
    }

    private static <EntityT> EntityT extractEntity(Row row, EntityHelper<EntityT> entityHelper) {
        if (row == null) {
            return null;
        }
        ColumnDefinitions cols = row.getColumnDefinitions();
        if (cols.size() == 1 && cols.get(0).getName().equals((Object)APPLIED)) {
            return null;
        }
        return (EntityT)entityHelper.get((GettableByName)row);
    }

    private static Uni<Long> extractCount(Row row) {
        if (row == null) {
            return Uni.createFrom().failure((Throwable)NO_ROW);
        }
        ColumnDefinitions columns = row.getColumnDefinitions();
        if (columns.size() == 0 || !columns.get(0).getType().equals(DataTypes.BIGINT)) {
            return Uni.createFrom().failure((Throwable)INVALID_ROW);
        }
        return Uni.createFrom().item((Object)row.getLong(0));
    }
}

