/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.internal.mapper.processor.dao;

import com.datastax.dse.driver.api.core.cql.reactive.ReactiveRow;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnType;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.DefaultDaoReturnTypeParser;
import com.datastax.oss.driver.internal.mapper.processor.dao.EntityUtils;
import com.datastax.oss.quarkus.internal.mapper.processor.dao.QuarkusDaoReturnTypeKind;
import com.datastax.oss.quarkus.runtime.api.reactive.MutinyReactiveResultSet;
import com.datastax.oss.quarkus.runtime.api.reactive.mapper.MutinyMappedReactiveResultSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class QuarkusDaoReturnTypeParser
extends DefaultDaoReturnTypeParser {
    private static final DaoReturnType MUTINY_REACTIVE_RESULT_SET = new DaoReturnType((DaoReturnTypeKind)QuarkusDaoReturnTypeKind.MUTINY_REACTIVE_RESULT_SET);
    private static final DaoReturnType MULTI_OF_ROW = new DaoReturnType((DaoReturnTypeKind)QuarkusDaoReturnTypeKind.MULTI_OF_ROW);
    private static final DaoReturnType MULTI_OF_REACTIVE_ROW = new DaoReturnType((DaoReturnTypeKind)QuarkusDaoReturnTypeKind.MULTI_OF_REACTIVE_ROW);
    private static final DaoReturnType UNI_OF_ROW = new DaoReturnType((DaoReturnTypeKind)QuarkusDaoReturnTypeKind.UNI_OF_ROW);
    private static final DaoReturnType UNI_OF_REACTIVE_ROW = new DaoReturnType((DaoReturnTypeKind)QuarkusDaoReturnTypeKind.UNI_OF_REACTIVE_ROW);
    private static final DaoReturnType UNI_OF_VOID = new DaoReturnType((DaoReturnTypeKind)QuarkusDaoReturnTypeKind.UNI_OF_VOID);
    private static final DaoReturnType UNI_OF_BOOLEAN = new DaoReturnType((DaoReturnTypeKind)QuarkusDaoReturnTypeKind.UNI_OF_BOOLEAN);
    private static final DaoReturnType UNI_OF_LONG = new DaoReturnType((DaoReturnTypeKind)QuarkusDaoReturnTypeKind.UNI_OF_LONG);

    public QuarkusDaoReturnTypeParser(ProcessorContext context) {
        super(context);
    }

    @NonNull
    public DaoReturnType parse(@NonNull TypeMirror returnTypeMirror, @NonNull Map<Name, TypeElement> typeParameters) {
        if (returnTypeMirror.getKind() == TypeKind.DECLARED) {
            TypeMirror typeArgumentMirror;
            DeclaredType returnTypeDeclared = (DeclaredType)returnTypeMirror;
            if (this.context.getClassUtils().isSame((TypeMirror)returnTypeDeclared, MutinyReactiveResultSet.class)) {
                return MUTINY_REACTIVE_RESULT_SET;
            }
            if (returnTypeDeclared.getTypeArguments().size() == 1 && (typeArgumentMirror = returnTypeDeclared.getTypeArguments().get(0)).getKind() == TypeKind.DECLARED) {
                TypeElement entityElement;
                Element returnTypeElement = returnTypeDeclared.asElement();
                if (this.context.getClassUtils().isSame(returnTypeElement, MutinyMappedReactiveResultSet.class) && (entityElement = EntityUtils.asEntityElement((TypeMirror)typeArgumentMirror, typeParameters)) != null) {
                    return new DaoReturnType((DaoReturnTypeKind)QuarkusDaoReturnTypeKind.MUTINY_MAPPED_REACTIVE_RESULT_SET, entityElement);
                }
                if (this.context.getClassUtils().isSame(returnTypeElement, Multi.class)) {
                    if (this.context.getClassUtils().isSame(typeArgumentMirror, Row.class)) {
                        return MULTI_OF_ROW;
                    }
                    if (this.context.getClassUtils().isSame(typeArgumentMirror, ReactiveRow.class)) {
                        return MULTI_OF_REACTIVE_ROW;
                    }
                    entityElement = EntityUtils.asEntityElement((TypeMirror)typeArgumentMirror, typeParameters);
                    if (entityElement != null) {
                        return new DaoReturnType((DaoReturnTypeKind)QuarkusDaoReturnTypeKind.MULTI_OF_ENTITY, entityElement);
                    }
                }
                if (this.context.getClassUtils().isSame(returnTypeElement, Uni.class)) {
                    if (this.context.getClassUtils().isSame(typeArgumentMirror, Row.class)) {
                        return UNI_OF_ROW;
                    }
                    if (this.context.getClassUtils().isSame(typeArgumentMirror, ReactiveRow.class)) {
                        return UNI_OF_REACTIVE_ROW;
                    }
                    if (this.context.getClassUtils().isSame(typeArgumentMirror, Void.class)) {
                        return UNI_OF_VOID;
                    }
                    if (this.context.getClassUtils().isSame(typeArgumentMirror, Boolean.class)) {
                        return UNI_OF_BOOLEAN;
                    }
                    if (this.context.getClassUtils().isSame(typeArgumentMirror, Long.class)) {
                        return UNI_OF_LONG;
                    }
                    entityElement = EntityUtils.asEntityElement((TypeMirror)typeArgumentMirror, typeParameters);
                    if (entityElement != null) {
                        return new DaoReturnType((DaoReturnTypeKind)QuarkusDaoReturnTypeKind.UNI_OF_ENTITY, entityElement);
                    }
                }
            }
        }
        return super.parse(returnTypeMirror, typeParameters);
    }
}

