/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.internal.mapper.processor.producer;

import com.datastax.oss.driver.api.mapper.annotations.Dao;
import com.datastax.oss.driver.api.mapper.annotations.DaoKeyspace;
import com.datastax.oss.driver.api.mapper.annotations.DaoProfile;
import com.datastax.oss.driver.api.mapper.annotations.DaoTable;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.util.Capitalizer;
import com.datastax.oss.driver.internal.mapper.processor.util.NameIndex;
import com.datastax.oss.quarkus.internal.mapper.processor.QuarkusGeneratedNames;
import com.datastax.oss.quarkus.internal.mapper.processor.mapper.QuarkusDaoFactoryMethodType;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import io.smallrye.mutiny.Uni;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class QuarkusDaoProducerMethodGenerator
implements MethodGenerator {
    private final ExecutableElement methodElement;
    private final ProcessorContext context;
    private final String methodName;
    private TypeName daoInterfaceName;
    private ParameterizedTypeName daoUniTypeName;
    private ParameterizedTypeName daoStageTypeName;
    private QuarkusDaoFactoryMethodType methodType;

    public QuarkusDaoProducerMethodGenerator(ExecutableElement methodElement, ProcessorContext context, NameIndex daoProducerMethodNames) {
        this.methodElement = methodElement;
        this.context = context;
        this.methodName = daoProducerMethodNames.uniqueField("produce" + Capitalizer.capitalize((String)methodElement.getSimpleName().toString()));
    }

    public Optional<MethodSpec> generate() {
        if (!this.validateReturnType()) {
            return Optional.empty();
        }
        if (!this.validateArguments()) {
            return Optional.empty();
        }
        this.daoStageTypeName = ParameterizedTypeName.get((ClassName)QuarkusGeneratedNames.COMPLETION_STAGE, (TypeName[])new TypeName[]{this.daoInterfaceName});
        this.daoUniTypeName = ParameterizedTypeName.get((ClassName)QuarkusGeneratedNames.UNI, (TypeName[])new TypeName[]{this.daoInterfaceName});
        if (this.methodType == QuarkusDaoFactoryMethodType.ASYNC) {
            return Optional.of(this.generateAsyncMethod());
        }
        if (this.methodType == QuarkusDaoFactoryMethodType.SYNC) {
            return Optional.of(this.generateSyncMethod());
        }
        return Optional.of(this.generateReactiveMethod());
    }

    private boolean validateReturnType() {
        TypeMirror returnTypeMirror = this.methodElement.getReturnType();
        if (returnTypeMirror.getKind() == TypeKind.DECLARED) {
            Element typeArgumentElement;
            TypeMirror typeArgument;
            DeclaredType declaredReturnType = (DeclaredType)returnTypeMirror;
            if (declaredReturnType.getTypeArguments().isEmpty()) {
                Element returnTypeElement = declaredReturnType.asElement();
                if (returnTypeElement.getAnnotation(Dao.class) != null) {
                    this.methodType = QuarkusDaoFactoryMethodType.SYNC;
                    this.daoInterfaceName = ClassName.get((TypeMirror)declaredReturnType);
                    return true;
                }
            } else if (this.context.getClassUtils().isFuture(declaredReturnType)) {
                Element typeArgumentElement2;
                TypeMirror typeArgument2 = declaredReturnType.getTypeArguments().get(0);
                if (typeArgument2.getKind() == TypeKind.DECLARED && (typeArgumentElement2 = ((DeclaredType)typeArgument2).asElement()).getAnnotation(Dao.class) != null) {
                    this.methodType = QuarkusDaoFactoryMethodType.ASYNC;
                    this.daoInterfaceName = ClassName.get((TypeMirror)typeArgument2);
                    return true;
                }
            } else if (this.context.getClassUtils().isSame(declaredReturnType.asElement(), Uni.class) && (typeArgument = declaredReturnType.getTypeArguments().get(0)).getKind() == TypeKind.DECLARED && (typeArgumentElement = ((DeclaredType)typeArgument).asElement()).getAnnotation(Dao.class) != null) {
                this.methodType = QuarkusDaoFactoryMethodType.REACTIVE;
                this.daoInterfaceName = ClassName.get((TypeMirror)typeArgument);
                return true;
            }
        }
        return false;
    }

    private boolean validateArguments() {
        Iterator<? extends VariableElement> iterator = this.methodElement.getParameters().iterator();
        if (iterator.hasNext()) {
            VariableElement parameterElement = iterator.next();
            if (parameterElement.getAnnotation(DaoKeyspace.class) != null) {
                this.context.getMessager().warn((Element)this.methodElement, "@%s annotation is not supported for automatic bean production; no injectable bean will be automatically produced for this method's returned value", new Object[]{DaoKeyspace.class.getSimpleName()});
                return false;
            }
            if (parameterElement.getAnnotation(DaoTable.class) != null) {
                this.context.getMessager().warn((Element)this.methodElement, "@%s annotation is not supported for automatic bean production; no injectable bean will be automatically produced for this method's returned value", new Object[]{DaoTable.class.getSimpleName()});
                return false;
            }
            if (parameterElement.getAnnotation(DaoProfile.class) != null) {
                this.context.getMessager().warn((Element)this.methodElement, "@%s annotation is not supported for automatic bean production; no injectable bean will be automatically produced for this method's returned value", new Object[]{DaoProfile.class.getSimpleName()});
                return false;
            }
            return false;
        }
        return true;
    }

    private MethodSpec generateAsyncMethod() {
        return MethodSpec.methodBuilder((String)this.methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(QuarkusGeneratedNames.PRODUCES).addAnnotation(QuarkusGeneratedNames.APPLICATION_SCOPED).addAnnotation(QuarkusGeneratedNames.DEFAULT_BEAN).addAnnotation(QuarkusGeneratedNames.DEFAULT).addAnnotation(QuarkusGeneratedNames.GENERATED_DAO_BEAN).returns((TypeName)this.daoStageTypeName).addStatement("return mapperStage.thenCompose(mapper -> mapper.$L())", new Object[]{this.methodElement.getSimpleName()}).build();
    }

    private MethodSpec generateSyncMethod() {
        return MethodSpec.methodBuilder((String)this.methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(QuarkusGeneratedNames.PRODUCES).addAnnotation(QuarkusGeneratedNames.APPLICATION_SCOPED).addAnnotation(QuarkusGeneratedNames.DEFAULT_BEAN).addAnnotation(QuarkusGeneratedNames.DEFAULT).addAnnotation(QuarkusGeneratedNames.GENERATED_DAO_BEAN).addException(ExecutionException.class).addException(InterruptedException.class).returns(this.daoInterfaceName).addStatement("return mapperStage.toCompletableFuture().get().$L()", new Object[]{this.methodElement.getSimpleName()}).build();
    }

    private MethodSpec generateReactiveMethod() {
        return MethodSpec.methodBuilder((String)this.methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(QuarkusGeneratedNames.PRODUCES).addAnnotation(QuarkusGeneratedNames.APPLICATION_SCOPED).addAnnotation(QuarkusGeneratedNames.DEFAULT_BEAN).addAnnotation(QuarkusGeneratedNames.DEFAULT).addAnnotation(QuarkusGeneratedNames.GENERATED_DAO_BEAN).returns((TypeName)this.daoUniTypeName).addStatement("return $T.createFrom().completionStage(mapperStage).flatMap(mapper -> mapper.$L())", new Object[]{QuarkusGeneratedNames.UNI, this.methodElement.getSimpleName()}).build();
    }
}

