/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.internal.mapper.processor;

import com.datastax.oss.driver.api.mapper.annotations.DaoFactory;
import com.datastax.oss.driver.api.mapper.annotations.Delete;
import com.datastax.oss.driver.api.mapper.annotations.Increment;
import com.datastax.oss.driver.api.mapper.annotations.Insert;
import com.datastax.oss.driver.api.mapper.annotations.Query;
import com.datastax.oss.driver.api.mapper.annotations.QueryProvider;
import com.datastax.oss.driver.api.mapper.annotations.Select;
import com.datastax.oss.driver.api.mapper.annotations.Update;
import com.datastax.oss.driver.internal.mapper.processor.CodeGenerator;
import com.datastax.oss.driver.internal.mapper.processor.DefaultCodeGeneratorFactory;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeParser;
import com.datastax.oss.driver.internal.mapper.processor.mapper.MapperImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.util.NameIndex;
import com.datastax.oss.quarkus.internal.mapper.processor.QuarkusProcessorContext;
import com.datastax.oss.quarkus.internal.mapper.processor.dao.QuarkusDaoDeleteMethodGenerator;
import com.datastax.oss.quarkus.internal.mapper.processor.dao.QuarkusDaoIncrementMethodGenerator;
import com.datastax.oss.quarkus.internal.mapper.processor.dao.QuarkusDaoInsertMethodGenerator;
import com.datastax.oss.quarkus.internal.mapper.processor.dao.QuarkusDaoQueryMethodGenerator;
import com.datastax.oss.quarkus.internal.mapper.processor.dao.QuarkusDaoQueryProviderMethodGenerator;
import com.datastax.oss.quarkus.internal.mapper.processor.dao.QuarkusDaoReturnTypeParser;
import com.datastax.oss.quarkus.internal.mapper.processor.dao.QuarkusDaoSelectMethodGenerator;
import com.datastax.oss.quarkus.internal.mapper.processor.dao.QuarkusDaoUpdateMethodGenerator;
import com.datastax.oss.quarkus.internal.mapper.processor.mapper.QuarkusMapperDaoFactoryMethodGenerator;
import com.datastax.oss.quarkus.internal.mapper.processor.mapper.QuarkusMapperGenerator;
import com.datastax.oss.quarkus.internal.mapper.processor.producer.QuarkusDaoProducerGenerator;
import com.datastax.oss.quarkus.internal.mapper.processor.producer.QuarkusDaoProducerMethodGenerator;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

public class QuarkusCodeGeneratorFactory
extends DefaultCodeGeneratorFactory {
    private final NameIndex daoProducerMethodNames = new NameIndex();
    private final QuarkusDaoReturnTypeParser daoReturnTypeParser = new QuarkusDaoReturnTypeParser(this.context);

    public QuarkusCodeGeneratorFactory(QuarkusProcessorContext quarkusProcessorContext) {
        super((ProcessorContext)quarkusProcessorContext);
    }

    public QuarkusDaoProducerGenerator newDaoProducer(TypeElement interfaceElement) {
        return new QuarkusDaoProducerGenerator(interfaceElement, this.context, this.daoProducerMethodNames);
    }

    public Optional<MethodGenerator> newDaoProducerMethod(ExecutableElement methodElement) {
        if (methodElement.getAnnotation(DaoFactory.class) == null) {
            return Optional.empty();
        }
        return Optional.of(new QuarkusDaoProducerMethodGenerator(methodElement, this.context, this.daoProducerMethodNames));
    }

    public CodeGenerator newMapper(TypeElement interfaceElement) {
        return new QuarkusMapperGenerator(interfaceElement, this.context);
    }

    public Optional<MethodGenerator> newMapperImplementationMethod(ExecutableElement methodElement, TypeElement processedType, MapperImplementationSharedCode enclosingClass) {
        if (methodElement.getAnnotation(DaoFactory.class) != null) {
            return Optional.of(new QuarkusMapperDaoFactoryMethodGenerator(methodElement, enclosingClass, this.context));
        }
        return Optional.empty();
    }

    public Optional<MethodGenerator> newDaoImplementationMethod(ExecutableElement methodElement, Map<Name, TypeElement> typeParameters, TypeElement processedType, DaoImplementationSharedCode enclosingClass) {
        if (methodElement.getAnnotation(Insert.class) != null) {
            return Optional.of(new QuarkusDaoInsertMethodGenerator(methodElement, typeParameters, processedType, enclosingClass, this.context));
        }
        if (methodElement.getAnnotation(Select.class) != null) {
            return Optional.of(new QuarkusDaoSelectMethodGenerator(methodElement, typeParameters, processedType, enclosingClass, this.context));
        }
        if (methodElement.getAnnotation(Delete.class) != null) {
            return Optional.of(new QuarkusDaoDeleteMethodGenerator(methodElement, typeParameters, processedType, enclosingClass, this.context));
        }
        if (methodElement.getAnnotation(Query.class) != null) {
            return Optional.of(new QuarkusDaoQueryMethodGenerator(methodElement, typeParameters, processedType, enclosingClass, this.context));
        }
        if (methodElement.getAnnotation(Update.class) != null) {
            return Optional.of(new QuarkusDaoUpdateMethodGenerator(methodElement, typeParameters, processedType, enclosingClass, this.context));
        }
        if (methodElement.getAnnotation(QueryProvider.class) != null) {
            return Optional.of(new QuarkusDaoQueryProviderMethodGenerator(methodElement, typeParameters, processedType, enclosingClass, this.context));
        }
        if (methodElement.getAnnotation(Increment.class) != null) {
            return Optional.of(new QuarkusDaoIncrementMethodGenerator(methodElement, typeParameters, processedType, enclosingClass, this.context));
        }
        return super.newDaoImplementationMethod(methodElement, typeParameters, processedType, enclosingClass);
    }

    public DaoReturnTypeParser getDaoReturnTypeParser() {
        return this.daoReturnTypeParser;
    }
}

