/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.internal.mapper.processor.dao;

import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeKind;
import com.datastax.oss.quarkus.runtime.internal.reactive.DefaultMutinyReactiveResultSet;
import com.datastax.oss.quarkus.runtime.internal.reactive.FailedMutinyReactiveResultSet;
import com.datastax.oss.quarkus.runtime.internal.reactive.MutinyWrappers;
import com.datastax.oss.quarkus.runtime.internal.reactive.mapper.DefaultMutinyMappedReactiveResultSet;
import com.datastax.oss.quarkus.runtime.internal.reactive.mapper.FailedMutinyMappedReactiveResultSet;
import com.datastax.oss.quarkus.runtime.internal.reactive.mapper.MapperMutinyWrappers;
import com.squareup.javapoet.CodeBlock;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

public enum QuarkusDaoReturnTypeKind implements DaoReturnTypeKind
{
    MUTINY_REACTIVE_RESULT_SET{

        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return new $T(executeReactive(boundStatement))", new Object[]{DefaultMutinyReactiveResultSet.class});
        }

        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 1.wrapWithErrorHandling(innerBlock, FAILED_MUTINY_REACTIVE_RESULT_SET);
        }
    }
    ,
    MUTINY_MAPPED_REACTIVE_RESULT_SET{

        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return new $T<>(executeReactiveAndMap(boundStatement, $L))", new Object[]{DefaultMutinyMappedReactiveResultSet.class, helperFieldName});
        }

        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 2.wrapWithErrorHandling(innerBlock, FAILED_MUTINY_MAPPED_REACTIVE_RESULT_SET);
        }
    }
    ,
    MULTI_OF_ROW{

        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return $T.toRowMulti(executeReactive(boundStatement))", new Object[]{MapperMutinyWrappers.class});
        }

        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 3.wrapWithErrorHandling(innerBlock, FAILED_MULTI);
        }
    }
    ,
    MULTI_OF_REACTIVE_ROW{

        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return new $T(executeReactive(boundStatement))", new Object[]{DefaultMutinyReactiveResultSet.class});
        }

        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 4.wrapWithErrorHandling(innerBlock, FAILED_MULTI);
        }
    }
    ,
    MULTI_OF_ENTITY{

        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return new $T<>(executeReactiveAndMap(boundStatement, $L))", new Object[]{DefaultMutinyMappedReactiveResultSet.class, helperFieldName});
        }

        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 5.wrapWithErrorHandling(innerBlock, FAILED_MULTI);
        }
    }
    ,
    UNI_OF_ROW{

        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return $T.toRowUni(executeReactive(boundStatement))", new Object[]{MapperMutinyWrappers.class});
        }

        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 6.wrapWithErrorHandling(innerBlock, FAILED_UNI);
        }
    }
    ,
    UNI_OF_REACTIVE_ROW{

        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return $T.toUni(executeReactive(boundStatement))", new Object[]{MutinyWrappers.class});
        }

        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 7.wrapWithErrorHandling(innerBlock, FAILED_UNI);
        }
    }
    ,
    UNI_OF_ENTITY{

        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return $T.toEntityUni(executeReactive(boundStatement), $L)", new Object[]{MapperMutinyWrappers.class, helperFieldName});
        }

        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 8.wrapWithErrorHandling(innerBlock, FAILED_UNI);
        }
    }
    ,
    UNI_OF_VOID{

        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return $T.toVoidUni(executeReactive(boundStatement))", new Object[]{MapperMutinyWrappers.class});
        }

        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 9.wrapWithErrorHandling(innerBlock, FAILED_UNI);
        }
    }
    ,
    UNI_OF_BOOLEAN{

        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return $T.toWasAppliedUni(executeReactive(boundStatement))", new Object[]{MapperMutinyWrappers.class});
        }

        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 10.wrapWithErrorHandling(innerBlock, FAILED_UNI);
        }
    }
    ,
    UNI_OF_LONG{

        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return $T.toCountUni(executeReactive(boundStatement))", new Object[]{MapperMutinyWrappers.class});
        }

        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 11.wrapWithErrorHandling(innerBlock, FAILED_UNI);
        }
    };

    private static final CodeBlock FAILED_MUTINY_REACTIVE_RESULT_SET;
    private static final CodeBlock FAILED_MUTINY_MAPPED_REACTIVE_RESULT_SET;
    private static final CodeBlock FAILED_MULTI;
    private static final CodeBlock FAILED_UNI;

    public String getDescription() {
        return this.name();
    }

    public boolean requiresReactive() {
        return true;
    }

    static CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, CodeBlock catchBlock) {
        return CodeBlock.builder().beginControlFlow("try", new Object[0]).add(innerBlock).nextControlFlow("catch ($T e)", new Object[]{Exception.class}).add(catchBlock).endControlFlow().build();
    }

    static {
        FAILED_MUTINY_REACTIVE_RESULT_SET = CodeBlock.builder().addStatement("return new $T(e)", new Object[]{FailedMutinyReactiveResultSet.class}).build();
        FAILED_MUTINY_MAPPED_REACTIVE_RESULT_SET = CodeBlock.builder().addStatement("return new $T<>(e)", new Object[]{FailedMutinyMappedReactiveResultSet.class}).build();
        FAILED_MULTI = CodeBlock.builder().addStatement("return $T.failedMulti(e)", new Object[]{MapperMutinyWrappers.class}).build();
        FAILED_UNI = CodeBlock.builder().addStatement("return $T.failedUni(e)", new Object[]{MapperMutinyWrappers.class}).build();
    }
}

