/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.internal.mapper.processor.mapper;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.mapper.annotations.Dao;
import com.datastax.oss.driver.api.mapper.annotations.DaoFactory;
import com.datastax.oss.driver.api.mapper.annotations.DaoKeyspace;
import com.datastax.oss.driver.api.mapper.annotations.DaoProfile;
import com.datastax.oss.driver.api.mapper.annotations.DaoTable;
import com.datastax.oss.driver.internal.mapper.DaoCacheKey;
import com.datastax.oss.driver.internal.mapper.processor.GeneratedNames;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.mapper.MapperImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.datastax.oss.quarkus.internal.mapper.processor.QuarkusGeneratedNames;
import com.datastax.oss.quarkus.internal.mapper.processor.mapper.QuarkusDaoFactoryMethodType;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import io.smallrye.mutiny.Uni;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class QuarkusMapperDaoFactoryMethodGenerator
implements MethodGenerator {
    private final ExecutableElement methodElement;
    private final MapperImplementationSharedCode enclosingClass;
    private final ProcessorContext context;
    private QuarkusDaoFactoryMethodType methodType;
    private TypeName daoFieldName;
    private ClassName daoImplementationName;
    private String keyspaceArgumentName;
    private String tableArgumentName;
    private String profileArgumentName;
    private boolean profileIsClass;

    public QuarkusMapperDaoFactoryMethodGenerator(ExecutableElement methodElement, MapperImplementationSharedCode enclosingClass, ProcessorContext context) {
        this.methodElement = methodElement;
        this.enclosingClass = enclosingClass;
        this.context = context;
    }

    public Optional<MethodSpec> generate() {
        if (!this.validateReturnType()) {
            return Optional.empty();
        }
        if (!this.validateArguments()) {
            return Optional.empty();
        }
        boolean isCachedByMethodArguments = this.keyspaceArgumentName != null || this.tableArgumentName != null || this.profileArgumentName != null;
        String fieldName = this.generateFieldDeclaration(isCachedByMethodArguments);
        MethodSpec.Builder methodBuilder = GeneratedCodePatterns.override((ExecutableElement)this.methodElement);
        if (isCachedByMethodArguments) {
            this.generateCacheKeyInstantiationStatement(methodBuilder);
            this.generateCacheKeyLookupStatement(fieldName, methodBuilder);
        } else {
            this.generateNonCachedStatement(fieldName, methodBuilder);
        }
        return Optional.of(methodBuilder.build());
    }

    private boolean validateReturnType() {
        TypeMirror returnTypeMirror = this.methodElement.getReturnType();
        if (returnTypeMirror.getKind() == TypeKind.DECLARED) {
            Element typeArgumentElement;
            TypeMirror typeArgument;
            DeclaredType declaredReturnType = (DeclaredType)returnTypeMirror;
            if (declaredReturnType.getTypeArguments().isEmpty()) {
                Element returnTypeElement = declaredReturnType.asElement();
                if (returnTypeElement.getAnnotation(Dao.class) != null) {
                    this.methodType = QuarkusDaoFactoryMethodType.SYNC;
                    this.daoFieldName = ClassName.get((TypeMirror)declaredReturnType);
                    this.daoImplementationName = GeneratedNames.daoImplementation((TypeElement)((TypeElement)returnTypeElement));
                }
            } else if (this.context.getClassUtils().isFuture(declaredReturnType)) {
                Element typeArgumentElement2;
                TypeMirror typeArgument2 = declaredReturnType.getTypeArguments().get(0);
                if (typeArgument2.getKind() == TypeKind.DECLARED && (typeArgumentElement2 = ((DeclaredType)typeArgument2).asElement()).getAnnotation(Dao.class) != null) {
                    this.methodType = QuarkusDaoFactoryMethodType.ASYNC;
                    this.daoFieldName = ClassName.get((TypeMirror)declaredReturnType);
                    this.daoImplementationName = GeneratedNames.daoImplementation((TypeElement)((TypeElement)typeArgumentElement2));
                }
            } else if (this.context.getClassUtils().isSame(declaredReturnType.asElement(), Uni.class) && (typeArgument = declaredReturnType.getTypeArguments().get(0)).getKind() == TypeKind.DECLARED && (typeArgumentElement = ((DeclaredType)typeArgument).asElement()).getAnnotation(Dao.class) != null) {
                this.methodType = QuarkusDaoFactoryMethodType.REACTIVE;
                this.daoFieldName = ParameterizedTypeName.get((ClassName)QuarkusGeneratedNames.COMPLETION_STAGE, (TypeName[])new TypeName[]{ClassName.get((TypeMirror)typeArgument)});
                this.daoImplementationName = GeneratedNames.daoImplementation((TypeElement)((TypeElement)typeArgumentElement));
            }
        }
        if (this.daoImplementationName == null) {
            this.context.getMessager().error((Element)this.methodElement, "Invalid return type: %s methods must return a %s-annotated interface, a future thereof, or a Uni thereof", new Object[]{DaoFactory.class.getSimpleName(), Dao.class.getSimpleName()});
            return false;
        }
        return true;
    }

    private boolean validateArguments() {
        for (VariableElement variableElement : this.methodElement.getParameters()) {
            if (variableElement.getAnnotation(DaoKeyspace.class) != null) {
                this.keyspaceArgumentName = this.validateKeyspaceOrTableParameter(variableElement, this.keyspaceArgumentName, DaoKeyspace.class, this.context);
                if (this.keyspaceArgumentName != null) continue;
                return false;
            }
            if (variableElement.getAnnotation(DaoTable.class) != null) {
                this.tableArgumentName = this.validateKeyspaceOrTableParameter(variableElement, this.tableArgumentName, DaoTable.class, this.context);
                if (this.tableArgumentName != null) continue;
                return false;
            }
            if (variableElement.getAnnotation(DaoProfile.class) != null) {
                this.profileArgumentName = this.validateExecutionProfile(variableElement, this.profileArgumentName, this.context);
                this.profileIsClass = this.context.getClassUtils().isSame(variableElement.asType(), DriverExecutionProfile.class);
                if (this.profileArgumentName != null) continue;
                return false;
            }
            this.context.getMessager().error((Element)this.methodElement, "Invalid parameter annotations: %s method parameters must be annotated with @%s, @%s or @%s", new Object[]{DaoFactory.class.getSimpleName(), DaoKeyspace.class.getSimpleName(), DaoTable.class.getSimpleName(), DaoProfile.class.getSimpleName()});
            return false;
        }
        return true;
    }

    private String generateFieldDeclaration(boolean isCachedByMethodArguments) {
        String suggestedFieldName = this.methodElement.getSimpleName() + "Cache";
        return isCachedByMethodArguments ? this.enclosingClass.addDaoMapField(suggestedFieldName, this.daoFieldName) : this.enclosingClass.addDaoSimpleField(suggestedFieldName, this.daoFieldName, (TypeName)this.daoImplementationName, this.methodType != QuarkusDaoFactoryMethodType.SYNC);
    }

    private void generateCacheKeyInstantiationStatement(MethodSpec.Builder methodBuilder) {
        methodBuilder.addCode("$1T key = new $1T(", new Object[]{DaoCacheKey.class});
        if (this.keyspaceArgumentName == null) {
            methodBuilder.addCode("($T)null", new Object[]{CqlIdentifier.class});
        } else {
            methodBuilder.addCode("$L", new Object[]{this.keyspaceArgumentName});
        }
        methodBuilder.addCode(", ", new Object[0]);
        if (this.tableArgumentName == null) {
            methodBuilder.addCode("($T)null", new Object[]{CqlIdentifier.class});
        } else {
            methodBuilder.addCode("$L", new Object[]{this.tableArgumentName});
        }
        methodBuilder.addCode(", ", new Object[0]);
        if (this.profileArgumentName == null) {
            methodBuilder.addCode("null, null);\n", new Object[0]);
        } else if (this.profileIsClass) {
            methodBuilder.addCode("null, $L);\n", new Object[]{this.profileArgumentName});
        } else {
            methodBuilder.addCode("$L, null);\n", new Object[]{this.profileArgumentName});
        }
    }

    private void generateCacheKeyLookupStatement(String fieldName, MethodSpec.Builder methodBuilder) {
        if (this.methodType == QuarkusDaoFactoryMethodType.SYNC) {
            methodBuilder.addStatement("return $L.computeIfAbsent(key, k -> $T.init(context.withDaoParameters(k.getKeyspaceId(), k.getTableId(), k.getExecutionProfileName(), k.getExecutionProfile())))", new Object[]{fieldName, this.daoImplementationName});
        } else if (this.methodType == QuarkusDaoFactoryMethodType.ASYNC) {
            methodBuilder.addStatement("return $L.computeIfAbsent(key, k -> $T.initAsync(context.withDaoParameters(k.getKeyspaceId(), k.getTableId(), k.getExecutionProfileName(), k.getExecutionProfile())))", new Object[]{fieldName, this.daoImplementationName});
        } else {
            methodBuilder.addStatement("return $L.computeIfAbsent(key, k -> return $T.createFrom().completionStage($T.initAsync(context.withDaoParameters(k.getKeyspaceId(), k.getTableId(), k.getExecutionProfileName(), k.getExecutionProfile()))))", new Object[]{fieldName, QuarkusGeneratedNames.UNI, this.daoImplementationName});
        }
    }

    private void generateNonCachedStatement(String fieldName, MethodSpec.Builder methodBuilder) {
        if (this.methodType == QuarkusDaoFactoryMethodType.REACTIVE) {
            methodBuilder.addStatement("return $T.createFrom().completionStage($L.get())", new Object[]{QuarkusGeneratedNames.UNI, fieldName});
        } else {
            methodBuilder.addStatement("return $L.get()", new Object[]{fieldName});
        }
    }

    private String validateKeyspaceOrTableParameter(VariableElement candidate, String previous, Class<?> annotation, ProcessorContext context) {
        if (this.isRepeatedAnnotation(candidate, previous, annotation, context)) {
            return null;
        }
        TypeMirror type = candidate.asType();
        if (!context.getClassUtils().isSame(type, String.class) && !context.getClassUtils().isSame(type, CqlIdentifier.class)) {
            context.getMessager().error((Element)candidate, "Invalid parameter type: @%s-annotated parameter of %s methods must be of type %s or %s", new Object[]{annotation.getSimpleName(), DaoFactory.class.getSimpleName(), String.class.getSimpleName(), CqlIdentifier.class.getSimpleName()});
            return null;
        }
        return candidate.getSimpleName().toString();
    }

    private String validateExecutionProfile(VariableElement candidate, String previous, ProcessorContext context) {
        if (this.isRepeatedAnnotation(candidate, previous, DaoProfile.class, context)) {
            return null;
        }
        TypeMirror type = candidate.asType();
        if (!context.getClassUtils().isSame(type, String.class) && !context.getClassUtils().isSame(type, DriverExecutionProfile.class)) {
            context.getMessager().error((Element)candidate, "Invalid parameter type: @%s-annotated parameter of %s methods must be of type %s or %s ", new Object[]{DaoProfile.class.getSimpleName(), DaoFactory.class.getSimpleName(), String.class.getSimpleName(), DriverExecutionProfile.class.getSimpleName()});
            return null;
        }
        return candidate.getSimpleName().toString();
    }

    private boolean isRepeatedAnnotation(VariableElement candidate, String previous, Class<?> annotation, ProcessorContext context) {
        if (previous != null) {
            context.getMessager().error((Element)candidate, "Invalid parameter annotations: only one %s method parameter can be annotated with @%s", new Object[]{DaoFactory.class.getSimpleName(), annotation.getSimpleName()});
            return true;
        }
        return false;
    }
}

