/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.internal.mapper.processor.producer;

import com.datastax.oss.driver.internal.mapper.processor.GeneratedNames;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.SingleFileCodeGenerator;
import com.datastax.oss.driver.internal.mapper.processor.util.Capitalizer;
import com.datastax.oss.driver.internal.mapper.processor.util.NameIndex;
import com.datastax.oss.quarkus.internal.mapper.processor.QuarkusCodeGeneratorFactory;
import com.datastax.oss.quarkus.internal.mapper.processor.QuarkusGeneratedNames;
import com.datastax.oss.quarkus.internal.mapper.processor.mapper.QuarkusMapperGenerator;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Generated;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class QuarkusDaoProducerGenerator
extends SingleFileCodeGenerator {
    private final TypeElement interfaceElement;
    private final ClassName producerName;
    private final ClassName builderName;
    private final String asyncMethodName;
    private final String syncMethodName;
    private final String reactiveMethodName;

    public QuarkusDaoProducerGenerator(TypeElement interfaceElement, ProcessorContext context, NameIndex daoProducerMethodNames) {
        super(context);
        this.interfaceElement = interfaceElement;
        this.producerName = QuarkusGeneratedNames.daoProducer(interfaceElement);
        this.builderName = GeneratedNames.mapperBuilder((TypeElement)interfaceElement);
        this.asyncMethodName = daoProducerMethodNames.uniqueField("produce" + Capitalizer.capitalize((String)interfaceElement.getSimpleName().toString()) + "Async");
        this.syncMethodName = daoProducerMethodNames.uniqueField("produce" + Capitalizer.capitalize((String)interfaceElement.getSimpleName().toString()) + "Sync");
        this.reactiveMethodName = daoProducerMethodNames.uniqueField("produce" + Capitalizer.capitalize((String)interfaceElement.getSimpleName().toString()) + "Reactive");
    }

    protected ClassName getPrincipalTypeName() {
        return this.producerName;
    }

    protected JavaFile.Builder getContents() {
        TypeSpec.Builder classContents = TypeSpec.classBuilder((ClassName)this.producerName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("A DAO bean producer for DAO factory methods declared in {@link $T}.", new Object[]{this.interfaceElement}).addJavadoc("\n\n<p>", new Object[0]).addJavadoc("Generated by the DataStax driver mapper, do not edit directly.\n", new Object[0]).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "\"$L\"", new Object[]{QuarkusMapperGenerator.class.getName()}).addMember("date", "\"$L\"", new Object[]{Instant.now().toString()}).build()).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "\"all\"", new Object[0]).build()).addField(FieldSpec.builder((TypeName)QuarkusGeneratedNames.SESSION_FUTURE, (String)"sessionStage", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build()).addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(CompletionStage.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)this.interfaceElement)}), (String)"mapperStage", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(QuarkusGeneratedNames.INJECT).addParameter((TypeName)QuarkusGeneratedNames.SESSION_FUTURE, "sessionStage", new Modifier[0]).addStatement("this.sessionStage = sessionStage", new Object[0]).addStatement("mapperStage = sessionStage.thenApply(session -> new $T(session).build())", new Object[]{this.builderName}).build());
        classContents.addMethod(this.generateMapperProducerAsyncMethod());
        classContents.addMethod(this.generateMapperProducerSyncMethod());
        classContents.addMethod(this.generateMapperProducerReactiveMethod());
        for (Element element : this.interfaceElement.getEnclosedElements()) {
            Optional<MethodGenerator> maybeGenerator;
            ExecutableElement methodElement;
            Set<Modifier> modifiers;
            if (element.getKind() != ElementKind.METHOD || (modifiers = (methodElement = (ExecutableElement)element).getModifiers()).contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.DEFAULT) || !(maybeGenerator = ((QuarkusCodeGeneratorFactory)this.context.getCodeGeneratorFactory()).newDaoProducerMethod(methodElement)).isPresent()) continue;
            maybeGenerator.flatMap(MethodGenerator::generate).ifPresent(arg_0 -> ((TypeSpec.Builder)classContents).addMethod(arg_0));
        }
        return JavaFile.builder((String)this.producerName.packageName(), (TypeSpec)classContents.build());
    }

    private MethodSpec generateMapperProducerAsyncMethod() {
        return MethodSpec.methodBuilder((String)this.asyncMethodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(QuarkusGeneratedNames.PRODUCES).addAnnotation(QuarkusGeneratedNames.APPLICATION_SCOPED).addAnnotation(QuarkusGeneratedNames.DEFAULT).addAnnotation(QuarkusGeneratedNames.DEFAULT_BEAN).addAnnotation(QuarkusGeneratedNames.GENERATED_MAPPER_BEAN).returns((TypeName)ParameterizedTypeName.get((ClassName)QuarkusGeneratedNames.COMPLETION_STAGE, (TypeName[])new TypeName[]{ClassName.get((TypeElement)this.interfaceElement)})).addStatement("return mapperStage", new Object[0]).build();
    }

    private MethodSpec generateMapperProducerSyncMethod() {
        return MethodSpec.methodBuilder((String)this.syncMethodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(QuarkusGeneratedNames.PRODUCES).addAnnotation(QuarkusGeneratedNames.APPLICATION_SCOPED).addAnnotation(QuarkusGeneratedNames.DEFAULT).addAnnotation(QuarkusGeneratedNames.DEFAULT_BEAN).addAnnotation(QuarkusGeneratedNames.GENERATED_MAPPER_BEAN).addException(ExecutionException.class).addException(InterruptedException.class).returns((TypeName)ClassName.get((TypeElement)this.interfaceElement)).addStatement("return mapperStage.toCompletableFuture().get()", new Object[0]).build();
    }

    private MethodSpec generateMapperProducerReactiveMethod() {
        return MethodSpec.methodBuilder((String)this.reactiveMethodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(QuarkusGeneratedNames.PRODUCES).addAnnotation(QuarkusGeneratedNames.APPLICATION_SCOPED).addAnnotation(QuarkusGeneratedNames.DEFAULT).addAnnotation(QuarkusGeneratedNames.DEFAULT_BEAN).addAnnotation(QuarkusGeneratedNames.GENERATED_MAPPER_BEAN).returns((TypeName)ParameterizedTypeName.get((ClassName)QuarkusGeneratedNames.UNI, (TypeName[])new TypeName[]{ClassName.get((TypeElement)this.interfaceElement)})).addStatement("return $T.createFrom().completionStage($L())", new Object[]{QuarkusGeneratedNames.UNI, this.asyncMethodName}).build();
    }
}

