/*
 * Copyright DataStax, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.stargate.sdk.core.domain;

import io.stargate.sdk.core.domain.Row;

/**
 * Row Mapper.
 *
 * @author Cedrick LUNVEN (@clunven)
 *
 * @param <T>
 *      object to marshall the row
 */
public interface RowMapper<T> {
    
    /**
     * Convert row to bean.
     *
     * @param row
     *      current row sent to API
     * @return
     *      marshalled bean
     */
    T map(Row row);

}
