/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk;

import io.stargate.sdk.Service;
import io.stargate.sdk.ServiceDatacenter;
import io.stargate.sdk.api.TokenProvider;
import io.stargate.sdk.loadbalancer.LoadBalancedResource;
import io.stargate.sdk.loadbalancer.LoadBalancingPolicy;
import io.stargate.sdk.loadbalancer.Loadbalancer;
import java.util.ArrayList;

public class ManagedServiceDatacenter<SERVICE extends Service> {
    private boolean available = true;
    private final String datacenterName;
    private final TokenProvider tokenProvider;
    private final Loadbalancer<SERVICE> stargateNodesLB;

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isNotAvailable() {
        return !this.available;
    }

    public ManagedServiceDatacenter(ServiceDatacenter<SERVICE> sc) {
        this.tokenProvider = sc.getTokenProvider();
        this.datacenterName = sc.getId();
        ArrayList lbs = new ArrayList();
        for (Service n : sc.getServices().values()) {
            LoadBalancedResource<Service> lbRsc = new LoadBalancedResource<Service>(n);
            lbRsc.setId(n.getId());
            lbRsc.setDefaultWeight(100.0 / (double)sc.getServices().values().size());
            lbRsc.setCurrentWeight(lbRsc.getDefaultWeight());
            lbRsc.setAvailable(true);
            lbRsc.setNbUse(0.0);
            lbs.add(lbRsc);
        }
        this.stargateNodesLB = new Loadbalancer(LoadBalancingPolicy.ROUND_ROBIN, lbs);
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public Loadbalancer<SERVICE> getStargateNodesLB() {
        return this.stargateNodesLB;
    }

    public String getDatacenterName() {
        return this.datacenterName;
    }

    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public String toString() {
        return "ManagedServiceDatacenter{available=" + this.available + ", datacenterName='" + this.datacenterName + '\'' + ", tokenProvider=" + this.tokenProvider + ", stargateNodesLB=" + this.stargateNodesLB + '}';
    }
}

