/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.audit;

import com.evanlennick.retry4j.Status;
import io.stargate.sdk.Service;
import io.stargate.sdk.audit.ServiceCallEvent;
import io.stargate.sdk.audit.ServiceCallObserver;
import io.stargate.sdk.utils.AnsiUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCallObserverAnsiLogger
implements ServiceCallObserver<String, Service, ServiceCallEvent<Service>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCallObserverAnsiLogger.class);

    @Override
    public void onCall(ServiceCallEvent event) {
        LOGGER.info("Service [" + AnsiUtils.yellow(((Service)event.getService()).getId()) + "]");
        LOGGER.info("[" + AnsiUtils.yellow(event.getRequestId()) + "] Endpoint         : [" + AnsiUtils.green(((Service)event.getService()).getId()) + "]");
        LOGGER.info("Request [" + AnsiUtils.yellow(event.getRequestId()) + "]");
        LOGGER.info("[" + AnsiUtils.yellow(event.getRequestId()) + "] Date             : [" + AnsiUtils.green(new Date(event.getTimestamp()).toString()) + "]");
        LOGGER.info("Response [" + AnsiUtils.magenta(event.getRequestId()) + "]");
        LOGGER.info("[" + AnsiUtils.magenta(event.getRequestId()) + "] Elapse Time      : [" + AnsiUtils.green(String.valueOf(event.getResponseElapsedTime())) + "] millis");
        LOGGER.info("[" + AnsiUtils.magenta(event.getRequestId()) + "] Total Time       : [" + AnsiUtils.green(String.valueOf(event.getResponseTime())) + "] millis");
        LOGGER.info("[" + AnsiUtils.magenta(event.getRequestId()) + "] Total Tries      : [" + AnsiUtils.green(String.valueOf(event.getTotalTries())) + "]");
        if (event.getErrorClass() != null) {
            LOGGER.info("Errors [" + AnsiUtils.red(event.getRequestId()) + "]");
            LOGGER.error("[" + AnsiUtils.red(event.getRequestId()) + "] Error Class      : [" + AnsiUtils.green(event.getErrorClass()) + "]");
            LOGGER.error("[" + AnsiUtils.red(event.getRequestId()) + "] Error Message    : [" + AnsiUtils.green(event.getErrorMessage()) + "]");
            LOGGER.error("[" + AnsiUtils.red(event.getRequestId()) + "] Error Exception  : [" + AnsiUtils.green(event.getLastException().getClass().getName()) + "]");
        }
    }

    @Override
    public void onSuccess(Status<String> s) {
        LOGGER.info("SUCCESS");
    }

    @Override
    public void onCompletion(Status<String> s) {
        LOGGER.info("COMPLETION");
    }

    @Override
    public void onFailure(Status<String> s) {
        LOGGER.info("FAILURE");
    }

    @Override
    public void onFailedTry(Status<String> s) {
        LOGGER.info("FAILED_TRY");
    }
}

