/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.core.domain;

import java.util.List;
import java.util.Optional;

public class Page<R> {
    private final int pageSize;
    private final String pageState;
    private List<R> results;

    public Page() {
        this(0, null, null);
    }

    public Page(int pageSize, String pageState) {
        this(pageSize, pageState, null);
    }

    public Page(int pageSize, String pageState, List<R> results) {
        this.pageSize = pageSize;
        this.pageState = pageState;
        this.results = results;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Optional<String> getPageState() {
        return Optional.ofNullable(this.pageState);
    }

    public List<R> getResults() {
        return this.results;
    }

    public R one() {
        if (this.getResults() == null || this.getResults().size() != 1) {
            throw new IllegalStateException("Current page does not contain a single record");
        }
        return this.getResults().get(0);
    }

    public void setResult(List<R> results) {
        this.results = results;
    }
}

