/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.http;

import io.stargate.sdk.ManagedServiceDeployment;
import io.stargate.sdk.ServiceDeployment;
import io.stargate.sdk.api.ApiConstants;
import io.stargate.sdk.http.RetryHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.domain.ApiResponseHttp;
import io.stargate.sdk.loadbalancer.LoadBalancedResource;
import io.stargate.sdk.loadbalancer.NoneResourceAvailableException;
import io.stargate.sdk.loadbalancer.UnavailableResourceException;
import java.util.function.Function;
import org.apache.hc.core5.http.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancedHttpClient
implements ApiConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadBalancedHttpClient.class);
    private final ManagedServiceDeployment<ServiceHttp> deployment;

    public LoadBalancedHttpClient(ServiceDeployment<ServiceHttp> conf) {
        this.deployment = new ManagedServiceDeployment<ServiceHttp>(conf);
    }

    public ApiResponseHttp GET(Function<ServiceHttp, String> mapper) {
        return this.GET(mapper, null);
    }

    public ApiResponseHttp GET(Function<ServiceHttp, String> mapper, String suffix) {
        return this.http(mapper, Method.GET, null, suffix, "application/json", false);
    }

    public ApiResponseHttp HEAD(Function<ServiceHttp, String> mapper) {
        return this.http(mapper, Method.PATCH, null, null, "application/json", false);
    }

    public ApiResponseHttp POST(Function<ServiceHttp, String> mapper) {
        return this.POST(mapper, null);
    }

    public ApiResponseHttp POST(Function<ServiceHttp, String> mapper, String body) {
        return this.http(mapper, Method.POST, body, null, "application/json", true);
    }

    public ApiResponseHttp POST_GRAPHQL(Function<ServiceHttp, String> mapper, String body) {
        return this.http(mapper, Method.POST, body, null, "application/graphql", true);
    }

    public ApiResponseHttp POST(Function<ServiceHttp, String> mapper, String body, String suffix) {
        return this.http(mapper, Method.POST, body, suffix, "application/json", true);
    }

    public ApiResponseHttp DELETE(Function<ServiceHttp, String> mapper) {
        return this.http(mapper, Method.DELETE, null, null, "application/json", true);
    }

    public ApiResponseHttp DELETE(Function<ServiceHttp, String> mapper, String suffix) {
        return this.http(mapper, Method.DELETE, null, suffix, "application/json", true);
    }

    public ApiResponseHttp PUT(Function<ServiceHttp, String> mapper, String body) {
        return this.http(mapper, Method.PUT, body, null, "application/json", false);
    }

    public ApiResponseHttp PUT(Function<ServiceHttp, String> mapper, String body, String suffix) {
        return this.http(mapper, Method.PUT, body, suffix, "application/json", false);
    }

    public ApiResponseHttp PATCH(Function<ServiceHttp, String> mapper, String body) {
        return this.http(mapper, Method.PATCH, body, null, "application/json", true);
    }

    public ApiResponseHttp PATCH(Function<ServiceHttp, String> mapper, String body, String suffix) {
        return this.http(mapper, Method.PATCH, body, suffix, "application/json", true);
    }

    private ApiResponseHttp http(Function<ServiceHttp, String> mapper, Method method, String body, String suffix, String contentType, boolean mandatory) {
        LoadBalancedResource<ServiceHttp> lb = null;
        while (true) {
            try {
                lb = this.deployment.lookupStargateNode();
                String targetEndPoint = mapper.apply(lb.getResource());
                if (null != suffix) {
                    targetEndPoint = targetEndPoint + suffix;
                }
                return RetryHttpClient.getInstance().executeHttp(lb.getResource(), method, targetEndPoint, this.deployment.lookupToken(), body, contentType, mandatory);
            }
            catch (UnavailableResourceException rex) {
                LOGGER.warn("A stargate node is down [{}], falling back to another node...", (Object)lb.getResource().getId());
                try {
                    this.deployment.failOverStargateNode(lb, rex);
                }
                catch (NoneResourceAvailableException nex) {
                    LOGGER.warn("No node availables is localDc [{}], falling back to another DC if available ...", (Object)this.deployment.getLocalDatacenterClient().getDatacenterName());
                    this.deployment.failOverDatacenter();
                }
                continue;
            }
            catch (NoneResourceAvailableException nex) {
                LOGGER.warn("No node availables is DataCenter [{}], falling back to another DC if available ...", (Object)this.deployment.getLocalDatacenterClient().getDatacenterName());
                this.deployment.failOverDatacenter();
                continue;
            }
            break;
        }
    }

    public ManagedServiceDeployment<ServiceHttp> getDeployment() {
        return this.deployment;
    }
}

