/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.http.auth;

import io.stargate.sdk.api.ApiConstants;
import io.stargate.sdk.api.TokenProvider;
import io.stargate.sdk.http.RetryHttpClient;
import io.stargate.sdk.http.domain.ApiResponseHttp;
import io.stargate.sdk.loadbalancer.Loadbalancer;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.JsonUtils;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class TokenProviderHttpAuth
implements TokenProvider,
ApiConstants {
    private static final String DEFAULT_SERVICE_ID = "sgv2-auth";
    public static final String DEFAULT_USERNAME = "cassandra";
    public static final String DEFAULT_PASSWORD = "cassandra";
    public static final String DEFAULT_AUTH_URL = "http://localhost:8081";
    public static Duration DEFAULT_TIMEOUT_TOKEN = Duration.ofMinutes(30L);
    private String username = "cassandra";
    private String password = "cassandra";
    private Duration tokenttl = DEFAULT_TIMEOUT_TOKEN;
    private long tokenCreatedtime = 0L;
    private String token;
    protected Loadbalancer<String> endPointAuthenticationLB;

    public TokenProviderHttpAuth() {
        this("cassandra", "cassandra", DEFAULT_AUTH_URL);
    }

    public TokenProviderHttpAuth(String username, String password) {
        this(username, password, DEFAULT_AUTH_URL);
    }

    public TokenProviderHttpAuth(String username, String password, String ... url) {
        this(username, password, Arrays.asList(url));
    }

    public TokenProviderHttpAuth(String username, String password, String url) {
        this(Collections.singletonList(url));
    }

    public TokenProviderHttpAuth(List<String> url) {
        this("cassandra", "cassandra", url);
    }

    public TokenProviderHttpAuth(String username, String password, List<String> url) {
        Assert.hasLength(username, "username list shoudl not be null");
        Assert.hasLength(password, "password list shoudl not be null");
        Assert.notNull(url, "Url list shoudl not be null");
        Assert.isTrue(url.size() > 0, "Url list should not be empty");
        this.username = username;
        this.password = password;
        this.endPointAuthenticationLB = new Loadbalancer<String>(url.toArray(new String[0]));
    }

    @Override
    public String getToken() {
        if (System.currentTimeMillis() - this.tokenCreatedtime > 1000L * this.tokenttl.getSeconds()) {
            this.token = this.renewToken();
            this.tokenCreatedtime = System.currentTimeMillis();
        }
        return this.token;
    }

    private String renewToken() {
        try {
            HttpPost httpPost = new HttpPost(this.endPointAuthenticationLB.get() + "/v1/auth");
            httpPost.addHeader("Content-Type", (Object)"application/json");
            httpPost.addHeader("User-Agent", (Object)REQUEST_WITH);
            httpPost.addHeader("X-Cassandra-Request-Id", (Object)UUID.randomUUID().toString());
            httpPost.addHeader("X-Requested-With", (Object)REQUEST_WITH);
            httpPost.setEntity((HttpEntity)new StringEntity("{" + "\"username\":" + JsonUtils.valueAsJson(this.username) + ", \"password\":" + JsonUtils.valueAsJson(this.password) + "}"));
            ApiResponseHttp response = RetryHttpClient.getInstance().executeHttp(null, (HttpUriRequestBase)httpPost, true);
            if (response != null && 201 == response.getCode() || 200 == response.getCode()) {
                return (String)JsonUtils.unmarshallBean(response.getBody(), Map.class).get("authToken");
            }
            throw new IllegalStateException("Cannot generate authentication token " + response.getBody());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot generate authentication token", e);
        }
    }
}

