/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.http.domain;

import io.stargate.sdk.http.domain.FilterCondition;
import io.stargate.sdk.utils.JsonUtils;
import java.util.Collection;
import java.util.Map;

public class Filter {
    private final String fieldName;
    private final FilterCondition condition;
    private final Object fieldValue;

    public Filter(String fieldName, FilterCondition cond, Object val) {
        this.fieldName = fieldName;
        this.condition = cond;
        this.fieldValue = val;
    }

    public String toString() {
        StringBuilder wherePiece = new StringBuilder("\"");
        wherePiece.append(this.fieldName);
        wherePiece.append("\": {\"");
        wherePiece.append(this.condition.getOperator());
        wherePiece.append("\":");
        if (this.fieldValue instanceof Collection) {
            wherePiece.append(JsonUtils.collectionAsJson((Collection)this.fieldValue));
        } else if (this.fieldValue instanceof Map) {
            wherePiece.append(JsonUtils.mapAsJson((Map)this.fieldValue));
        } else {
            wherePiece.append(JsonUtils.valueAsJson(this.fieldValue));
        }
        wherePiece.append("}");
        return wherePiece.toString();
    }
}

