/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.core.domain;

import java.util.List;
import java.util.Optional;

public class Page<R> {
    private final int pageSize;
    private final String pageState;
    private List<R> results;

    public Page() {
        this(0, null, null);
    }

    public Page(int pageSize, String pageState) {
        this(pageSize, pageState, null);
    }

    public Page(int pageSize, String pageState, List<R> results) {
        this.pageState = pageState;
        this.results = results;
        this.pageSize = pageSize;
    }

    public boolean isEmpty() {
        return this.results == null || this.results.isEmpty();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setResults(List<R> results) {
        this.results = results;
    }

    public List<R> getResults() {
        return this.results;
    }

    public Optional<R> getFindFirst() {
        if (!this.isEmpty()) {
            return Optional.ofNullable(this.results.get(0));
        }
        return Optional.empty();
    }

    public R one() {
        if (this.getResults() == null || this.getResults().size() != 1) {
            throw new IllegalStateException("Current page does not contain a single record");
        }
        return this.getResults().get(0);
    }

    public Optional<String> getPageState() {
        return Optional.ofNullable(this.pageState);
    }
}

