/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.http.audit;

import io.stargate.sdk.api.ApiConstants;
import io.stargate.sdk.audit.ServiceCallEvent;
import io.stargate.sdk.http.ServiceHttp;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class ServiceHttpCallEvent
extends ServiceCallEvent<ServiceHttp>
implements ApiConstants {
    protected String httpRequestMethod;
    protected String httpRequestUrl;
    protected Map<String, String> httpRequestHeaders = new HashMap<String, String>();
    protected String httpRequestBody;
    protected int httpResponseCode;
    protected Map<String, String> httpResponseHeaders = new HashMap<String, String>();
    protected String httpResponseBody;

    public ServiceHttpCallEvent(ServiceHttp service, ClassicHttpRequest req) {
        this.timestamp = System.currentTimeMillis();
        this.service = service;
        try {
            if (req.containsHeader("X-Cassandra-Request-Id")) {
                this.requestId = req.getHeader("X-Cassandra-Request-Id").getValue();
            }
            this.httpRequestMethod = req.getMethod();
            this.httpRequestUrl = req.getUri().toString();
            for (Header h : req.getHeaders()) {
                if (h.getName().equalsIgnoreCase("Authorization") || h.getName().equalsIgnoreCase("X-Cassandra-Token")) {
                    this.httpRequestHeaders.put(h.getName(), "***");
                    continue;
                }
                this.httpRequestHeaders.put(h.getName(), h.getValue());
            }
            if (req.getEntity() != null) {
                this.httpRequestBody = EntityUtils.toString((HttpEntity)req.getEntity());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getHttpRequestMethod() {
        return this.httpRequestMethod;
    }

    public String getHttpRequestUrl() {
        return this.httpRequestUrl;
    }

    public Map<String, String> getHttpRequestHeaders() {
        return this.httpRequestHeaders;
    }

    public String getHttpRequestBody() {
        return this.httpRequestBody;
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public Map<String, String> getHttpResponseHeaders() {
        return this.httpResponseHeaders;
    }

    public String getHttpResponseBody() {
        return this.httpResponseBody;
    }

    public void setHttpRequestMethod(String httpRequestMethod) {
        this.httpRequestMethod = httpRequestMethod;
    }

    public void setHttpRequestUrl(String httpRequestUrl) {
        this.httpRequestUrl = httpRequestUrl;
    }

    public void setHttpRequestHeaders(Map<String, String> httpRequestHeaders) {
        this.httpRequestHeaders = httpRequestHeaders;
    }

    public void setHttpRequestBody(String httpRequestBody) {
        this.httpRequestBody = httpRequestBody;
    }

    public void setHttpResponseCode(int httpResponseCode) {
        this.httpResponseCode = httpResponseCode;
    }

    public void setHttpResponseHeaders(Map<String, String> httpResponseHeaders) {
        this.httpResponseHeaders = httpResponseHeaders;
    }

    public void setHttpResponseBody(String httpResponseBody) {
        this.httpResponseBody = httpResponseBody;
    }
}

