/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.http;

import com.evanlennick.retry4j.CallExecutorBuilder;
import com.evanlennick.retry4j.Status;
import com.evanlennick.retry4j.config.RetryConfig;
import com.evanlennick.retry4j.config.RetryConfigBuilder;
import io.stargate.sdk.api.ApiConstants;
import io.stargate.sdk.audit.ServiceCallObserver;
import io.stargate.sdk.exception.AlreadyExistException;
import io.stargate.sdk.exception.AuthenticationException;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.audit.ServiceHttpCallEvent;
import io.stargate.sdk.http.domain.ApiResponseHttp;
import io.stargate.sdk.loadbalancer.UnavailableResourceException;
import io.stargate.sdk.utils.CompletableFutures;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryHttpClient
implements ApiConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryHttpClient.class);
    public static final int DEFAULT_TIMEOUT_REQUEST = 20;
    public static final int DEFAULT_TIMEOUT_CONNECT = 20;
    public static final int DEFAULT_RETRY_COUNT = 3;
    public static final Duration DEFAULT_RETRY_DELAY = Duration.ofMillis(100L);
    public static LinkedHashMap<String, String> userAgents = new LinkedHashMap();
    private static RetryHttpClient _instance = null;
    protected CloseableHttpClient httpClient = null;
    protected static Map<String, ServiceCallObserver<?, ?, ?>> apiInvocationsObserversMap = new ConcurrentHashMap();
    protected static RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("strict").setExpectContinueEnabled(true).setConnectionRequestTimeout(Timeout.ofSeconds((long)20L)).setResponseTimeout(Timeout.ofSeconds((long)20L)).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).build();
    protected static RetryConfig retryConfig = new RetryConfigBuilder().retryOnAnyException().withDelayBetweenTries(DEFAULT_RETRY_DELAY).withExponentialBackoff().withMaxNumberOfTries(3).build();

    public static void withRetryConfig(RetryConfig conf) {
        retryConfig = conf;
    }

    public static void withRequestConfig(RequestConfig conf) {
        requestConfig = conf;
    }

    public static void registerListener(String name, ServiceCallObserver<?, ?, ?> listener) {
        apiInvocationsObserversMap.put(name, listener);
    }

    private RetryHttpClient() {
    }

    public static synchronized RetryHttpClient getInstance() {
        if (_instance == null) {
            _instance = new RetryHttpClient();
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
            connManager.setValidateAfterInactivity(TimeValue.ofSeconds((long)10L));
            connManager.setMaxTotal(100);
            connManager.setDefaultMaxPerRoute(10);
            RetryHttpClient._instance.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        }
        return _instance;
    }

    public void pushUserAgent(String component, String version) {
        if (!userAgents.containsKey(component)) {
            userAgents.put(component, version);
        }
    }

    public String getUserAgentHeader() {
        if (userAgents.isEmpty()) {
            userAgents.put("data-api-client-java", ApiConstants.class.getPackage().getImplementationVersion());
        }
        ArrayList<Map.Entry<String, String>> entryList = new ArrayList<Map.Entry<String, String>>(userAgents.entrySet());
        StringBuilder sb = new StringBuilder();
        for (int i = entryList.size() - 1; i >= 0; --i) {
            Map.Entry entry = (Map.Entry)entryList.get(i);
            sb.append((String)entry.getKey()).append("/").append((String)entry.getValue());
            if (i <= 0) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public ApiResponseHttp GET(ServiceHttp sHttp, String url, String token) {
        return this.executeHttp(sHttp, Method.GET, url, token, null, "application/json", false);
    }

    public ApiResponseHttp HEAD(ServiceHttp sHttp, String url, String token) {
        return this.executeHttp(sHttp, Method.HEAD, url, token, null, "application/json", false);
    }

    public ApiResponseHttp POST(ServiceHttp sHttp, String url, String token) {
        return this.executeHttp(sHttp, Method.POST, url, token, null, "application/json", true);
    }

    public ApiResponseHttp POST(ServiceHttp sHttp, String url, String token, String body) {
        return this.executeHttp(sHttp, Method.POST, url, token, body, "application/json", true);
    }

    public ApiResponseHttp POST_GRAPHQL(ServiceHttp sHttp, String url, String token, String body) {
        return this.executeHttp(sHttp, Method.POST, url, token, body, "application/graphql", true);
    }

    public ApiResponseHttp DELETE(ServiceHttp sHttp, String url, String token) {
        return this.executeHttp(sHttp, Method.DELETE, url, token, null, "application/json", true);
    }

    public ApiResponseHttp PUT(ServiceHttp sHttp, String url, String token, String body) {
        return this.executeHttp(sHttp, Method.PUT, url, token, body, "application/json", false);
    }

    public ApiResponseHttp PATCH(ServiceHttp sHttp, String url, String token, String body) {
        return this.executeHttp(sHttp, Method.PATCH, url, token, body, "application/json", true);
    }

    public ApiResponseHttp executeHttp(ServiceHttp sHttp, Method method, String url, String token, String reqBody, String contentType, boolean mandatory) {
        return this.executeHttp(sHttp, this.buildRequest(method, url, token, reqBody, contentType), mandatory);
    }

    public ApiResponseHttp executeHttp(ServiceHttp sHttp, HttpUriRequestBase req, boolean mandatory) {
        ServiceHttpCallEvent event = new ServiceHttpCallEvent(sHttp, (ClassicHttpRequest)req);
        Status<CloseableHttpResponse> status = this.executeWithRetries((ClassicHttpRequest)req);
        try {
            ApiResponseHttp res = this.mapResponse(status, event);
            if (404 == res.getCode() && !mandatory) {
                ApiResponseHttp apiResponseHttp = res;
                return apiResponseHttp;
            }
            if (res.getCode() >= 300) {
                LOGGER.error("Error for request [{}], url={}, method={}, code={}, body={}", new Object[]{event.getRequestId(), req.getUri().toString(), req.getMethod(), res.getCode(), res.getBody()});
                this.processErrors(res, mandatory);
                this.logHttpError(res);
            }
            ApiResponseHttp apiResponseHttp = res;
            return apiResponseHttp;
        }
        catch (UnavailableResourceException e) {
            event.setErrorClass(e.getClass().getName());
            event.setErrorMessage(e.getMessage());
            throw e;
        }
        catch (IllegalArgumentException e) {
            event.setErrorClass(e.getClass().getName());
            event.setErrorMessage(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            event.setErrorClass(e.getClass().getName());
            event.setErrorMessage(e.getMessage());
            throw new RuntimeException("Error in HTTP Request", e);
        }
        finally {
            CompletableFuture.runAsync(() -> this.notifyAsync(listener -> listener.onCall(event)));
        }
    }

    private ApiResponseHttp mapResponse(Status<CloseableHttpResponse> status, ServiceHttpCallEvent event) throws ParseException, IOException {
        ApiResponseHttp res;
        event.setTotalTries(status.getTotalTries());
        event.setLastException(status.getLastExceptionThatCausedRetry());
        event.setResponseElapsedTime(status.getTotalElapsedDuration().toMillis());
        try (CloseableHttpResponse response = (CloseableHttpResponse)status.getResult();){
            event.setResponseTimestamp(status.getEndTime());
            if (response == null) {
                event.setHttpResponseCode(503);
                res = new ApiResponseHttp("Response is empty, please check url", 503, null);
            } else {
                event.setHttpResponseCode(response.getCode());
                HashMap<String, String> headers = new HashMap<String, String>();
                Arrays.stream(response.getHeaders()).forEach(h -> headers.put(h.getName(), h.getValue()));
                event.setHttpResponseHeaders(headers);
                String body = null;
                if (null != response.getEntity()) {
                    body = EntityUtils.toString((HttpEntity)response.getEntity());
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                event.setHttpResponseBody(body);
                res = new ApiResponseHttp(body, response.getCode(), headers);
            }
        }
        return res;
    }

    private CompletionStage<Void> notifyAsync(Consumer<ServiceCallObserver> lambda) {
        return CompletableFutures.allDone(apiInvocationsObserversMap.values().stream().map(l -> CompletableFuture.runAsync(() -> lambda.accept((ServiceCallObserver)l))).collect(Collectors.toList()));
    }

    private HttpUriRequestBase buildRequest(Method method, String url, String token, String body, String contentType) {
        HttpGet req;
        switch (method) {
            case GET: {
                req = new HttpGet(url);
                break;
            }
            case POST: {
                req = new HttpPost(url);
                break;
            }
            case PUT: {
                req = new HttpPut(url);
                break;
            }
            case DELETE: {
                req = new HttpDelete(url);
                break;
            }
            case PATCH: {
                req = new HttpPatch(url);
                break;
            }
            case HEAD: {
                req = new HttpHead(url);
                break;
            }
            case TRACE: {
                req = new HttpTrace(url);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid HTTP Method");
            }
        }
        req.addHeader("Content-Type", (Object)contentType);
        req.addHeader("Accept", (Object)"application/json");
        req.addHeader("User-Agent", (Object)this.getUserAgentHeader());
        req.addHeader("X-Requested-With", (Object)this.getUserAgentHeader());
        System.out.println("User-Agent: " + this.getUserAgentHeader());
        req.addHeader("X-Cassandra-Request-Id", (Object)UUID.randomUUID().toString());
        req.addHeader("X-Cassandra-Token", (Object)token);
        req.addHeader("Authorization", (Object)("Bearer " + token));
        req.setConfig(requestConfig);
        if (null != body) {
            req.setEntity((HttpEntity)new StringEntity(body, ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8)));
        }
        return req;
    }

    private Status<CloseableHttpResponse> executeWithRetries(ClassicHttpRequest req) {
        Callable<CloseableHttpResponse> executeRequest = () -> this.httpClient.execute(req);
        return new CallExecutorBuilder().config(retryConfig).onSuccessListener(s -> CompletableFuture.runAsync(() -> this.notifyAsync(listener -> listener.onSuccess(s)))).onCompletionListener(s -> CompletableFuture.runAsync(() -> this.notifyAsync(listener -> listener.onCompletion(s)))).onFailureListener(s -> {
            LOGGER.error("Calls failed after {} retries", (Object)s.getTotalTries());
            CompletableFuture.runAsync(() -> this.notifyAsync(listener -> listener.onFailure(s)));
        }).afterFailedTryListener(s -> {
            LOGGER.error("Failure on attempt {}/{} ", (Object)s.getTotalTries(), (Object)retryConfig.getMaxNumberOfTries());
            try {
                LOGGER.error("Failed request {} on {}", (Object)req.getMethod(), (Object)req.getUri());
                LOGGER.error("+ Exception was ", (Throwable)s.getLastExceptionThatCausedRetry());
            }
            catch (URISyntaxException e) {
                LOGGER.error("Cannot display URI ", (Throwable)e);
            }
            CompletableFuture.runAsync(() -> this.notifyAsync(listener -> listener.onFailedTry(s)));
        }).build().execute(executeRequest);
    }

    private void processErrors(ApiResponseHttp res, boolean mandatory) {
        switch (res.getCode()) {
            case 400: {
                throw new IllegalArgumentException("Error Code=" + res.getCode() + " (HTTP_BAD_REQUEST) Invalid Parameters: " + res.getBody());
            }
            case 401: {
                throw new AuthenticationException("Error Code=" + res.getCode() + ", (HTTP_UNAUTHORIZED) Invalid Credentials Check your token: " + res.getBody());
            }
            case 403: {
                throw new AuthenticationException("Error Code=" + res.getCode() + ", (HTTP_FORBIDDEN) Invalid permissions, check your token: " + res.getBody());
            }
            case 404: {
                if (!mandatory) break;
                throw new IllegalArgumentException("Error Code=" + res.getCode() + "(HTTP_NOT_FOUND) Object not found:  " + res.getBody());
            }
            case 409: {
                throw new AlreadyExistException("Error Code=" + res.getCode() + ", (HTTP_CONFLICT) Object may already exist with same identifiers: " + res.getBody());
            }
            case 422: {
                throw new IllegalArgumentException("Error Code=" + res.getCode() + "(422) Invalid information provided to create DB: " + res.getBody());
            }
            default: {
                if (res.getCode() == 503) {
                    throw new UnavailableResourceException(res.getBody() + " (http:" + res.getCode() + ")");
                }
                throw new RuntimeException(res.getBody() + " (http:" + res.getCode() + ")");
            }
        }
    }

    private void logHttpError(ApiResponseHttp res) {
        LOGGER.error("An HTTP Error occurred. The HTTP CODE Return is {}", (Object)res.getCode());
    }

    public static RequestConfig getRequestConfig() {
        return requestConfig;
    }

    public static RetryConfig getRetryConfig() {
        return retryConfig;
    }
}

