/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.domain;

import io.stargate.sdk.data.domain.SimilarityMetric;
import java.util.Arrays;
import java.util.List;

public class CollectionDefinition {
    private String name;
    private Options options;

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionDefinition)) {
            return false;
        }
        CollectionDefinition other = (CollectionDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Options this$options = this.getOptions();
        Options other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectionDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Options $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    public String toString() {
        return "CollectionDefinition(name=" + this.getName() + ", options=" + String.valueOf(this.getOptions()) + ")";
    }

    public static class Builder {
        String name;
        Options options;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder vectorDimension(int size) {
            if (this.options == null) {
                this.options = new Options();
            }
            if (this.options.vector == null) {
                this.options.vector = new Options.Vector();
            }
            this.options.vector.dimension = size;
            return this;
        }

        public Builder indexingDeny(String ... properties) {
            if (properties != null) {
                if (this.options == null) {
                    this.options = new Options();
                }
                if (this.options.indexing == null) {
                    this.options.indexing = new Indexing();
                }
                if (this.options.indexing.allow != null) {
                    throw new IllegalStateException("'indexing.deny' and 'indexing.allow' are mutually exclusive");
                }
                this.options.indexing.deny = Arrays.asList(properties);
            }
            return this;
        }

        public Builder indexingAllow(String ... properties) {
            if (properties != null) {
                if (this.options.indexing == null) {
                    this.options.indexing = new Indexing();
                }
                if (this.options.indexing.deny != null) {
                    throw new IllegalStateException("'indexing.deny' and 'indexing.allow' are mutually exclusive");
                }
                this.options.indexing.allow = Arrays.asList(properties);
            }
            return this;
        }

        public Builder vector(int dimension, SimilarityMetric function) {
            this.similarityMetric(function);
            this.vectorDimension(dimension);
            return this;
        }

        public Builder similarityMetric(SimilarityMetric function) {
            if (this.options == null) {
                this.options = new Options();
            }
            if (this.options.vector == null) {
                this.options.vector = new Options.Vector();
            }
            this.options.vector.metric = function;
            return this;
        }

        public CollectionDefinition build() {
            CollectionDefinition req = new CollectionDefinition();
            req.name = this.name;
            req.options = this.options;
            return req;
        }
    }

    public static class Options {
        private Vector vector;
        private Indexing indexing;

        public Vector getVector() {
            return this.vector;
        }

        public Indexing getIndexing() {
            return this.indexing;
        }

        public void setVector(Vector vector) {
            this.vector = vector;
        }

        public void setIndexing(Indexing indexing) {
            this.indexing = indexing;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options other = (Options)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Vector this$vector = this.getVector();
            Vector other$vector = other.getVector();
            if (this$vector == null ? other$vector != null : !((Object)this$vector).equals(other$vector)) {
                return false;
            }
            Indexing this$indexing = this.getIndexing();
            Indexing other$indexing = other.getIndexing();
            return !(this$indexing == null ? other$indexing != null : !((Object)this$indexing).equals(other$indexing));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Options;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Vector $vector = this.getVector();
            result = result * 59 + ($vector == null ? 43 : ((Object)$vector).hashCode());
            Indexing $indexing = this.getIndexing();
            result = result * 59 + ($indexing == null ? 43 : ((Object)$indexing).hashCode());
            return result;
        }

        public String toString() {
            return "CollectionDefinition.Options(vector=" + String.valueOf(this.getVector()) + ", indexing=" + String.valueOf(this.getIndexing()) + ")";
        }

        public static class Vector {
            private int dimension;
            private SimilarityMetric metric;

            public int getDimension() {
                return this.dimension;
            }

            public SimilarityMetric getMetric() {
                return this.metric;
            }

            public void setDimension(int dimension) {
                this.dimension = dimension;
            }

            public void setMetric(SimilarityMetric metric) {
                this.metric = metric;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Vector)) {
                    return false;
                }
                Vector other = (Vector)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getDimension() != other.getDimension()) {
                    return false;
                }
                SimilarityMetric this$metric = this.getMetric();
                SimilarityMetric other$metric = other.getMetric();
                return !(this$metric == null ? other$metric != null : !((Object)((Object)this$metric)).equals((Object)other$metric));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Vector;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getDimension();
                SimilarityMetric $metric = this.getMetric();
                result = result * 59 + ($metric == null ? 43 : ((Object)((Object)$metric)).hashCode());
                return result;
            }

            public String toString() {
                return "CollectionDefinition.Options.Vector(dimension=" + this.getDimension() + ", metric=" + String.valueOf((Object)this.getMetric()) + ")";
            }
        }

        public static class Vectorize {
            private String service;
            private OptionsForVectorize options;

            public String getService() {
                return this.service;
            }

            public OptionsForVectorize getOptions() {
                return this.options;
            }

            public void setService(String service) {
                this.service = service;
            }

            public void setOptions(OptionsForVectorize options) {
                this.options = options;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Vectorize)) {
                    return false;
                }
                Vectorize other = (Vectorize)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$service = this.getService();
                String other$service = other.getService();
                if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
                    return false;
                }
                OptionsForVectorize this$options = this.getOptions();
                OptionsForVectorize other$options = other.getOptions();
                return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Vectorize;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $service = this.getService();
                result = result * 59 + ($service == null ? 43 : $service.hashCode());
                OptionsForVectorize $options = this.getOptions();
                result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
                return result;
            }

            public String toString() {
                return "CollectionDefinition.Options.Vectorize(service=" + this.getService() + ", options=" + String.valueOf(this.getOptions()) + ")";
            }

            public static class OptionsForVectorize {
                private String modelName;

                public String getModelName() {
                    return this.modelName;
                }

                public void setModelName(String modelName) {
                    this.modelName = modelName;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof OptionsForVectorize)) {
                        return false;
                    }
                    OptionsForVectorize other = (OptionsForVectorize)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$modelName = this.getModelName();
                    String other$modelName = other.getModelName();
                    return !(this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof OptionsForVectorize;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $modelName = this.getModelName();
                    result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
                    return result;
                }

                public String toString() {
                    return "CollectionDefinition.Options.Vectorize.OptionsForVectorize(modelName=" + this.getModelName() + ")";
                }
            }
        }
    }

    public static class Indexing {
        private List<String> deny;
        private List<String> allow;

        public List<String> getDeny() {
            return this.deny;
        }

        public List<String> getAllow() {
            return this.allow;
        }

        public void setDeny(List<String> deny) {
            this.deny = deny;
        }

        public void setAllow(List<String> allow) {
            this.allow = allow;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Indexing)) {
                return false;
            }
            Indexing other = (Indexing)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$deny = this.getDeny();
            List<String> other$deny = other.getDeny();
            if (this$deny == null ? other$deny != null : !((Object)this$deny).equals(other$deny)) {
                return false;
            }
            List<String> this$allow = this.getAllow();
            List<String> other$allow = other.getAllow();
            return !(this$allow == null ? other$allow != null : !((Object)this$allow).equals(other$allow));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Indexing;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $deny = this.getDeny();
            result = result * 59 + ($deny == null ? 43 : ((Object)$deny).hashCode());
            List<String> $allow = this.getAllow();
            result = result * 59 + ($allow == null ? 43 : ((Object)$allow).hashCode());
            return result;
        }

        public String toString() {
            return "CollectionDefinition.Indexing(deny=" + String.valueOf(this.getDeny()) + ", allow=" + String.valueOf(this.getAllow()) + ")";
        }
    }
}

