/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.domain;

import io.stargate.sdk.data.domain.DocumentMutationStatus;
import io.stargate.sdk.data.domain.JsonDocument;
import io.stargate.sdk.data.domain.JsonDocumentMutationResult;
import io.stargate.sdk.data.domain.odm.Document;
import io.stargate.sdk.utils.JsonUtils;
import java.util.Map;

public class DocumentMutationResult<T> {
    Document<T> document;
    DocumentMutationStatus status;

    public DocumentMutationResult() {
        this.status = DocumentMutationStatus.NOT_PROCESSED;
    }

    public DocumentMutationResult(Document<T> doc) {
        this(doc, DocumentMutationStatus.NOT_PROCESSED);
    }

    public DocumentMutationResult(Document<T> doc, DocumentMutationStatus status) {
        this.document = doc;
        this.status = status;
    }

    public JsonDocumentMutationResult asJsonDocumentMutationResult() {
        JsonDocument doc = new JsonDocument();
        doc.id(this.document.getId());
        doc.data((Map)JsonUtils.convertValueForDataApi(this.document.getData(), Map.class));
        return new JsonDocumentMutationResult(doc, this.status);
    }

    public Document<T> getDocument() {
        return this.document;
    }

    public DocumentMutationStatus getStatus() {
        return this.status;
    }

    public void setDocument(Document<T> document) {
        this.document = document;
    }

    public void setStatus(DocumentMutationStatus status) {
        this.status = status;
    }
}

