/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.domain;

import io.stargate.sdk.data.domain.odm.Document;
import io.stargate.sdk.utils.JsonUtils;
import java.lang.reflect.Array;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class JsonDocument
extends Document<Map<String, Object>> {
    public JsonDocument() {
        this.data = new HashMap();
    }

    public JsonDocument(String json) {
        this.data(json);
        this.parseIdAndVector();
    }

    private void parseIdAndVector() {
        if (((Map)this.data).containsKey("_id")) {
            this.id = (String)((Map)this.data).get("_id");
            ((Map)this.data).remove("_id");
        }
        if (((Map)this.data).containsKey("$vector")) {
            List doubleList = (List)((Map)this.data).get("$vector");
            this.vector = new float[doubleList.size()];
            for (int i = 0; i < doubleList.size(); ++i) {
                this.vector[i] = ((Double)doubleList.get(i)).floatValue();
            }
            ((Map)this.data).remove("$vector");
        }
    }

    public JsonDocument(Map<String, Object> keyValue) {
        this.data = keyValue;
        this.parseIdAndVector();
    }

    public JsonDocument id(String id) {
        this.id = id;
        return this;
    }

    public JsonDocument vector(float[] vector) {
        this.vector = vector;
        return this;
    }

    public JsonDocument data(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    public JsonDocument data(String json) {
        this.data = json == null ? null : JsonUtils.unmarshallBean((String)json, Map.class);
        return this;
    }

    public JsonDocument put(String key, Object value) {
        if (null == this.data) {
            this.data = new LinkedHashMap();
        }
        ((Map)this.data).put(key, value);
        return this;
    }

    private <K> K get(String key, Class<K> type) {
        Objects.requireNonNull(type, "Type is required");
        if (((Map)this.data).containsKey(key)) {
            if (type.isAssignableFrom(((Map)this.data).get(key).getClass())) {
                return (K)((Map)this.data).get(key);
            }
            if (type.equals(Long.class) && ((Map)this.data).get(key) instanceof Integer) {
                return (K)Long.valueOf(((Integer)((Map)this.data).get(key)).intValue());
            }
            if (type.equals(Short.class) && ((Map)this.data).get(key) instanceof Integer) {
                return (K)Short.valueOf(((Integer)((Map)this.data).get(key)).shortValue());
            }
            if (type.equals(Byte.class) && ((Map)this.data).get(key) instanceof Integer) {
                return (K)Byte.valueOf(((Integer)((Map)this.data).get(key)).byteValue());
            }
            if (type.equals(Float.class) && ((Map)this.data).get(key) instanceof Double) {
                return (K)Float.valueOf(((Double)((Map)this.data).get(key)).floatValue());
            }
            if (type.equals(Character.class) && ((Map)this.data).get(key) instanceof String) {
                return (K)Character.valueOf(((String)((Map)this.data).get(key)).charAt(0));
            }
            if (type.equals(UUID.class) && ((Map)this.data).get(key) instanceof String) {
                return (K)UUID.fromString((String)((Map)this.data).get(key));
            }
            throw new IllegalArgumentException("Argument '" + key + "' is not a " + type.getSimpleName() + " but a " + ((Map)this.data).get(key).getClass().getSimpleName());
        }
        return null;
    }

    public <K> List<K> getList(String k, Class<K> itemClass) {
        return this.get(k, List.class);
    }

    public <K> K[] getArray(String k, Class<K> itemClass) {
        List<K> list = this.getList(k, itemClass);
        Object[] array = (Object[])Array.newInstance(itemClass, list.size());
        return list.toArray(array);
    }

    public <T> T getObject(String k, Class<T> type) {
        return (T)JsonUtils.convertValueForDataApi(((Map)this.data).get(k), type);
    }

    public String getString(String k) {
        return this.get(k, String.class);
    }

    public Double getDouble(String k) {
        return this.get(k, Double.class);
    }

    public Integer getInteger(String k) {
        return this.get(k, Integer.class);
    }

    public Boolean getBoolean(String k) {
        return this.get(k, Boolean.class);
    }

    public UUID getUUID(String k) {
        String uuid = this.getString(k);
        return uuid == null ? null : UUID.fromString(uuid);
    }

    public Float getFloat(String k) {
        return this.get(k, Float.class);
    }

    public Long getLong(String k) {
        return this.get(k, Long.class);
    }

    public Short getShort(String k) {
        return this.get(k, Short.class);
    }

    public Byte getByte(String k) {
        return this.get(k, Byte.class);
    }

    public Character getCharacter(String k) {
        return this.get(k, Character.class);
    }

    public Date getDate(String k) {
        return this.getObject(k, Date.class);
    }

    public Calendar getCalendar(String k) {
        return this.getObject(k, Calendar.class);
    }

    public Instant getInstant(String k) {
        return this.getObject(k, Instant.class);
    }

    public boolean isAttributeExist(String key) {
        return ((Map)this.data).containsKey(key);
    }
}

