/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.domain.query;

import io.stargate.sdk.data.domain.query.Filter;
import io.stargate.sdk.http.domain.FilterKeyword;
import io.stargate.sdk.http.domain.FilterOperator;
import java.util.Map;

public class FilterBuilder {
    private final String fieldName;
    private final Filter filter;

    protected FilterBuilder(Filter filter, String fieldName) {
        this.filter = filter;
        this.fieldName = fieldName;
    }

    private Filter simpleOperator(FilterOperator cond, Object value) {
        this.filter.filter.put(this.fieldName, Map.of(cond.getOperator(), value));
        return this.filter;
    }

    private Filter simpleKeyword(FilterKeyword key, Object value) {
        this.filter.filter.put(this.fieldName, Map.of(key.getKeyword(), value));
        return this.filter;
    }

    public Filter isEqualsTo(Object value) {
        this.filter.filter.put(this.fieldName, value);
        return this.filter;
    }

    public Filter isAnArrayContaining(Object ... value) {
        return this.simpleOperator(FilterOperator.EQUALS_TO, value);
    }

    public Filter isAnArrayExactlyEqualsTo(Object[] value) {
        this.filter.filter.put(this.fieldName, Map.of(FilterKeyword.ALL.getKeyword(), value));
        return this.filter;
    }

    public Filter hasSubFieldsEqualsTo(Map<String, Object> value) {
        return this.simpleOperator(FilterOperator.EQUALS_TO, value);
    }

    public Filter isLessThan(Object value) {
        return this.simpleOperator(FilterOperator.LESS_THAN, value);
    }

    public Filter isLessOrEqualsThan(Object value) {
        return this.simpleOperator(FilterOperator.LESS_THAN_OR_EQUALS_TO, value);
    }

    public Filter isGreaterThan(Object value) {
        return this.simpleOperator(FilterOperator.GREATER_THAN, value);
    }

    public Filter isGreaterOrEqualsThan(Object value) {
        return this.simpleOperator(FilterOperator.GREATER_THAN_OR_EQUALS_TO, value);
    }

    public Filter isNotEqualsTo(Object value) {
        return this.simpleOperator(FilterOperator.NOT_EQUALS_TO, value);
    }

    public Filter exists() {
        return this.simpleKeyword(FilterKeyword.EXISTS, true);
    }

    public Filter hasSize(int size) {
        return this.simpleKeyword(FilterKeyword.SIZE, true);
    }
}

