/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data;

import io.stargate.sdk.core.domain.Page;
import io.stargate.sdk.data.CollectionClient;
import io.stargate.sdk.data.domain.DocumentMutationResult;
import io.stargate.sdk.data.domain.odm.Document;
import io.stargate.sdk.data.domain.odm.DocumentResult;
import io.stargate.sdk.data.domain.query.DeleteQuery;
import io.stargate.sdk.data.domain.query.DeleteResult;
import io.stargate.sdk.data.domain.query.Filter;
import io.stargate.sdk.data.domain.query.SelectQuery;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public class CollectionRepository<DOC> {
    protected final CollectionClient collectionClient;
    protected final Class<DOC> docClass;

    public CollectionRepository(CollectionClient col, Class<DOC> clazz) {
        this.collectionClient = col;
        this.docClass = clazz;
    }

    public String getName() {
        return this.collectionClient.getCollection();
    }

    public boolean exists(String id) {
        return this.collectionClient.isDocumentExists(id);
    }

    public DocumentMutationResult<DOC> insert(Document<DOC> bean) {
        return this.collectionClient.insertOne(bean);
    }

    public CompletableFuture<DocumentMutationResult<DOC>> insertASync(Document<DOC> bean) {
        return this.collectionClient.insertOneASync(bean);
    }

    public final List<DocumentMutationResult<DOC>> insert(List<Document<DOC>> documents) {
        return this.collectionClient.insertMany(documents);
    }

    public final CompletableFuture<List<DocumentMutationResult<DOC>>> insertASync(List<Document<DOC>> documents) {
        return this.collectionClient.insertManyASync(documents);
    }

    public final List<DocumentMutationResult<DOC>> insert(List<Document<DOC>> documents, int chunkSize, int concurrency) {
        return this.collectionClient.insertManyChunked(documents, chunkSize, concurrency);
    }

    public final CompletableFuture<List<DocumentMutationResult<DOC>>> insertASync(List<Document<DOC>> documents, int chunkSize, int concurrency) {
        return this.collectionClient.insertManyChunkedASync(documents, chunkSize, concurrency);
    }

    public final DocumentMutationResult<DOC> save(Document<DOC> current) {
        return this.collectionClient.upsertOne(current);
    }

    public final CompletableFuture<DocumentMutationResult<DOC>> saveASync(Document<DOC> current) {
        return this.collectionClient.upsertOneASync(current);
    }

    public final List<DocumentMutationResult<DOC>> saveAll(List<Document<DOC>> documentList) {
        return this.collectionClient.upsertMany(documentList);
    }

    public final CompletableFuture<List<DocumentMutationResult<DOC>>> saveAllASync(List<Document<DOC>> documentList) {
        return this.collectionClient.upsertManyASync(documentList);
    }

    public final List<DocumentMutationResult<DOC>> saveAll(List<Document<DOC>> documentList, int chunkSize, int concurrency) {
        return this.collectionClient.upsertManyChunked(documentList, chunkSize, concurrency);
    }

    public final CompletableFuture<List<DocumentMutationResult<DOC>>> saveAllASync(List<Document<DOC>> documentList, int chunkSize, int concurrency) {
        return this.collectionClient.upsertManyChunkedASync(documentList, chunkSize, concurrency);
    }

    public final int count() {
        return this.count(null);
    }

    public final int count(Filter jsonFilter) {
        return this.collectionClient.countDocuments(jsonFilter);
    }

    public Optional<DocumentResult<DOC>> find(@NonNull SelectQuery query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        return this.collectionClient.findOne(query, this.docClass);
    }

    public Optional<DocumentResult<DOC>> findById(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.collectionClient.findById(id, this.docClass);
    }

    public Stream<DocumentResult<DOC>> search() {
        return this.collectionClient.findAll(this.docClass);
    }

    public Stream<DocumentResult<DOC>> search(SelectQuery query) {
        return this.collectionClient.find(query, this.docClass);
    }

    public Page<DocumentResult<DOC>> searchPage(SelectQuery query) {
        return this.collectionClient.findPage(query, this.docClass);
    }

    public boolean delete(@NonNull Document<DOC> document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (document.getId() != null) {
            return this.collectionClient.deleteById(document.getId()).getDeletedCount() > 0;
        }
        if (document.getVector() != null) {
            return this.collectionClient.deleteByVector(document.getVector()).getDeletedCount() > 0;
        }
        throw new IllegalArgumentException("Cannot delete record without id or vector");
    }

    public DeleteResult deleteAll() {
        return this.collectionClient.deleteAll();
    }

    public int deleteAll(List<Document<DOC>> documents) {
        List futures = documents.stream().map(record -> CompletableFuture.supplyAsync(() -> this.delete((Document<DOC>)record) ? 1 : 0)).collect(Collectors.toList());
        return futures.stream().map(CompletableFuture::join).mapToInt(Integer::intValue).sum();
    }

    public DeleteResult deleteAll(DeleteQuery deleteQuery) {
        return this.collectionClient.deleteMany(deleteQuery);
    }

    public DeleteResult deleteAllChunked(DeleteQuery deleteQuery, int concurrency) {
        return this.collectionClient.deleteManyChunked(deleteQuery, concurrency);
    }

    public DeleteResult deletePage(DeleteQuery deleteQuery) {
        return this.collectionClient.deleteManyPaged(deleteQuery);
    }

    public Optional<DocumentResult<DOC>> findByVector(float[] vector) {
        return this.collectionClient.findOneByVector(vector, this.docClass);
    }

    public boolean deleteByVector(float[] vector) {
        return this.collectionClient.deleteByVector(vector).getDeletedCount() > 0;
    }

    public boolean deleteById(String id) {
        return this.collectionClient.deleteById(id).getDeletedCount() > 0;
    }

    public Page<DocumentResult<DOC>> findVector(float[] vector, Filter metadataFilter) {
        return this.collectionClient.findVectorPage(vector, metadataFilter, null, null, this.docClass);
    }

    public List<DocumentResult<DOC>> findVector(float[] vector, Integer limit) {
        return this.collectionClient.findVectorPage(vector, null, limit, null, this.docClass).getResults();
    }

    public List<DocumentResult<DOC>> findVector(float[] vector, Filter metadataFilter, Integer limit) {
        return this.collectionClient.findVectorPage(vector, metadataFilter, limit, null, this.docClass).getResults();
    }

    public CollectionClient getCollectionClient() {
        return this.collectionClient;
    }

    public Class<DOC> getDocClass() {
        return this.docClass;
    }
}

