/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.domain.query;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.stargate.sdk.data.domain.query.FilterBuilder;
import io.stargate.sdk.data.domain.query.FilterBuilderList;
import io.stargate.sdk.http.domain.FilterOperator;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class Filter {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    Map<String, Object> filter = new HashMap<String, Object>();

    public Filter() {
    }

    public Filter(String json) {
        this.filter = (Map)JsonUtils.unmarshallBean((String)json, Map.class);
    }

    public Filter(Map<String, Object> obj) {
        this.filter = obj;
    }

    public Filter(@NonNull String fieldName, @NonNull FilterOperator cond, @NonNull Object value) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (cond == null) {
            throw new NullPointerException("cond is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.filter.put(fieldName, Map.of(cond.getOperator(), value));
    }

    public FilterBuilder where(String fieldName) {
        Assert.hasLength((String)fieldName, (String)"fieldName");
        this.filter = new HashMap<String, Object>();
        return new FilterBuilder(this, fieldName);
    }

    public Filter where(String fieldName, FilterOperator cond, Object value) {
        this.filter.put(fieldName, Map.of(cond.getOperator(), value));
        return this;
    }

    public FilterBuilderList and() {
        return new FilterBuilderList(this, "$and");
    }

    public FilterBuilderList or() {
        return new FilterBuilderList(this, "$or");
    }

    public FilterBuilderList not() {
        return new FilterBuilderList(this, "$not");
    }

    public static Filter findById(String id) {
        return new Filter().where("_id").isEqualsTo(id);
    }

    public String toString() {
        return this.toJson();
    }

    public String toJson() {
        return JsonUtils.marshallForDataApi((Object)this);
    }

    public Map<String, Object> getFilter() {
        return this.filter;
    }
}

