/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.domain.query;

import io.stargate.sdk.data.domain.query.Filter;
import io.stargate.sdk.http.domain.FilterOperator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilterBuilderList
extends Filter {
    private final String keyword;
    private final Filter parentFilter;

    public FilterBuilderList(Filter parentFilter, String key) {
        this.keyword = key;
        this.parentFilter = parentFilter;
        this.filter = new HashMap();
        this.filter.put(key, new ArrayList());
    }

    @Override
    public FilterBuilderList where(String field, FilterOperator op, Object result) {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        map.put(field, Map.of(op.getOperator(), result));
        this.getConditions().add(map);
        return this;
    }

    public Filter end() {
        if ("$and".equals(this.keyword) || "$or".equals(this.keyword)) {
            if (this.getConditions().size() < 2) {
                throw new IllegalArgumentException(this.keyword + " should have more than 1 condition");
            }
            if (this.parentFilter instanceof FilterBuilderList) {
                ((FilterBuilderList)this.parentFilter).getConditions().add(this.filter);
            } else {
                this.parentFilter.getFilter().putAll(this.filter);
            }
        }
        if ("$not".equals(this.keyword)) {
            if (this.getConditions().size() != 1) {
                throw new IllegalArgumentException(this.keyword + " should have a single condition");
            }
            HashMap<String, Map<String, Object>> val = new HashMap<String, Map<String, Object>>();
            val.put(this.keyword, this.getConditions().get(0));
            if (this.parentFilter instanceof FilterBuilderList) {
                ((FilterBuilderList)this.parentFilter).getConditions().add(val);
            } else {
                this.parentFilter.getFilter().putAll(val);
            }
        }
        return this.parentFilter;
    }

    private List<Map<String, Object>> getConditions() {
        return (List)this.filter.get(this.keyword);
    }
}

