/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.domain.query;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.stargate.sdk.data.domain.query.Filter;
import io.stargate.sdk.data.domain.query.SelectQueryBuilder;
import io.stargate.sdk.http.domain.FilterKeyword;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SelectQuery {
    public static final int PAGING_SIZE_MAX = 20;
    private Map<String, Object> projection;
    private Map<String, Object> filter;
    private Map<String, Object> sort;
    private Map<String, Object> options;

    public SelectQuery() {
    }

    public static SelectQueryBuilder builder() {
        return new SelectQueryBuilder();
    }

    public SelectQuery(Filter pFilter) {
        if (pFilter != null) {
            this.filter = new HashMap<String, Object>();
            this.filter.putAll(pFilter.filter);
        }
    }

    public SelectQuery(float[] vector, Filter pFilter) {
        if (vector != null) {
            this.sort = new HashMap<String, Object>();
            this.sort.put(FilterKeyword.VECTOR.getKeyword(), vector);
        }
        if (pFilter != null) {
            this.filter = new HashMap<String, Object>();
            this.filter.putAll(pFilter.filter);
        }
    }

    public SelectQuery(SelectQueryBuilder builder) {
        this.projection = builder.projection;
        this.filter = builder.filter;
        this.sort = builder.sort;
        this.options = builder.options;
    }

    public static SelectQuery findById(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return SelectQuery.builder().filter(Filter.findById(id)).build();
    }

    public static SelectQuery findByVector(float[] vector) {
        if (vector == null) {
            throw new IllegalArgumentException("vector cannot be null");
        }
        return SelectQuery.builder().orderByAnn(vector).build();
    }

    public static SelectQuery findWithFilter(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter cannot be null");
        }
        return SelectQuery.builder().filter(filter).build();
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.options != null && this.options.containsKey("limit")) {
            return Optional.ofNullable((Integer)this.options.get("limit"));
        }
        return Optional.empty();
    }

    @JsonIgnore
    public void setPageState(String pageState) {
        if (this.options == null) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put("pagingState", pageState);
    }

    public Map<String, Object> getProjection() {
        return this.projection;
    }

    public Map<String, Object> getFilter() {
        return this.filter;
    }

    public Map<String, Object> getSort() {
        return this.sort;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setProjection(Map<String, Object> projection) {
        this.projection = projection;
    }

    public void setFilter(Map<String, Object> filter) {
        this.filter = filter;
    }

    public void setSort(Map<String, Object> sort) {
        this.sort = sort;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }
}

