/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.domain.query;

import io.stargate.sdk.data.domain.query.Filter;
import io.stargate.sdk.data.domain.query.SelectQuery;
import io.stargate.sdk.http.domain.FilterKeyword;
import io.stargate.sdk.http.domain.FilterOperator;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class SelectQueryBuilder {
    public Map<String, Object> projection;
    public Map<String, Object> sort;
    public Map<String, Object> options;
    public Map<String, Object> filter;

    public SelectQueryBuilder select(String ... keys) {
        if (null == this.projection) {
            this.projection = new HashMap<String, Object>();
        }
        if (keys != null) {
            for (String key : keys) {
                this.projection.put(key, 1);
            }
        }
        return this;
    }

    public SelectQueryBuilder orderBy(String key, Object value) {
        if (null == this.sort) {
            this.sort = new HashMap<String, Object>();
        }
        this.sort.put(key, value);
        return this;
    }

    public SelectQueryBuilder orderByAnn(float[] vector) {
        if (vector == null) {
            return this;
        }
        return this.orderBy(FilterKeyword.VECTOR.getKeyword(), vector);
    }

    public SelectQueryBuilder orderByAnn(@NonNull String textFragment) {
        if (textFragment == null) {
            throw new NullPointerException("textFragment is marked non-null but is null");
        }
        return this.orderBy(FilterKeyword.VECTORIZE.getKeyword(), textFragment);
    }

    public SelectQueryBuilder withLimit(Integer limit) {
        if (limit == null || limit > 20) {
            return this;
        }
        return this.withOption("limit", limit);
    }

    public SelectQueryBuilder withSkip(Integer skip) {
        if (skip == null) {
            return this;
        }
        return this.withOption("skip", skip);
    }

    public SelectQueryBuilder withPagingState(String pagingState) {
        if (pagingState == null) {
            return this;
        }
        return this.withOption("pagingState", pagingState);
    }

    public SelectQueryBuilder includeSimilarity() {
        return this.withOption("includeSimilarity", "true");
    }

    public SelectQueryBuilder withoutVector() {
        if (null == this.projection) {
            this.projection = new HashMap<String, Object>();
        }
        this.projection.put(FilterKeyword.VECTOR.getKeyword(), 0);
        return this;
    }

    protected SelectQueryBuilder withOption(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (null == this.options) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put(key, value);
        return this;
    }

    public SelectQueryBuilder filter(Filter pFilter) {
        if (pFilter == null) {
            return this;
        }
        if (this.filter == null) {
            this.filter = new HashMap<String, Object>();
        }
        this.filter.putAll(pFilter.filter);
        return this;
    }

    public SelectQueryBuilder where(String fieldName, FilterOperator op, Object value) {
        return this.filter(new Filter(fieldName, op, value));
    }

    public SelectQuery build() {
        return new SelectQuery(this);
    }
}

