/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.domain.query;

import io.stargate.sdk.data.domain.odm.Document;
import io.stargate.sdk.data.domain.query.Filter;
import io.stargate.sdk.data.domain.query.UpdateQuery;
import io.stargate.sdk.http.domain.FilterKeyword;
import io.stargate.sdk.http.domain.FilterOperator;
import io.stargate.sdk.utils.JsonUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class UpdateQueryBuilder {
    public Map<String, Object> sort;
    public Map<String, Object> options;
    public Map<String, Object> filter;
    public Map<String, Object> update;
    public Document<?> replacement;

    public UpdateQueryBuilder orderBy(String key, Object value) {
        if (null == this.sort) {
            this.sort = new HashMap<String, Object>();
        }
        this.sort.put(key, value);
        return this;
    }

    public UpdateQueryBuilder orderByAnn(float[] vector) {
        return this.orderBy(FilterKeyword.VECTOR.getKeyword(), vector);
    }

    public UpdateQueryBuilder orderByAnn(String textFragment) {
        return this.orderBy(FilterKeyword.VECTORIZE.getKeyword(), textFragment);
    }

    public UpdateQueryBuilder withUpsert() {
        return this.withOption("upsert", true);
    }

    public UpdateQueryBuilder withReturnDocument(ReturnDocument returnDocument) {
        return this.withOption("returnDocument", returnDocument.name());
    }

    public UpdateQueryBuilder enableUpsert() {
        return this.withOption("upsert", true);
    }

    protected UpdateQueryBuilder withOption(String key, Object value) {
        if (null == this.options) {
            this.options = new HashMap<String, Object>();
        }
        this.options.put(key, value);
        return this;
    }

    public UpdateQueryBuilder filter(String jsonFilter) {
        this.filter = (Map)JsonUtils.unmarshallBean((String)jsonFilter, Map.class);
        return this;
    }

    public UpdateQueryBuilder filter(Filter pFilter) {
        if (pFilter == null) {
            return this;
        }
        if (this.filter == null) {
            this.filter = new HashMap<String, Object>();
        }
        this.filter.putAll(pFilter.filter);
        return this;
    }

    public UpdateQueryBuilder where(String fieldName, FilterOperator op, Object value) {
        return this.filter(new Filter(fieldName, op, value));
    }

    public UpdateQueryBuilder withJsonUpdate(String jsonUpdate) {
        this.update = (Map)JsonUtils.unmarshallBean((String)jsonUpdate, Map.class);
        return this;
    }

    public <DOC> UpdateQueryBuilder replaceBy(Document<DOC> replacement) {
        this.replacement = replacement;
        return this;
    }

    public UpdateQueryBuilder updateInc(String key, Integer offset) {
        return this.update("$inc", key, offset);
    }

    public UpdateQueryBuilder updateUnset(String key) {
        return this.update("$unset", key, "");
    }

    public UpdateQueryBuilder updateSet(String key, Object value) {
        return this.update("$set", key, value);
    }

    public UpdateQueryBuilder updateMin(String key, Object value) {
        return this.update("$min", key, value);
    }

    public UpdateQueryBuilder updatePush(String key, Object value) {
        return this.update("$push", key, value);
    }

    public UpdateQueryBuilder updatePop(String key, Object value) {
        return this.update("$pop", key, value);
    }

    public UpdateQueryBuilder updatePushEach(String key, List<Object> values, Integer position) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("$each", values);
        if (null != position) {
            value.put("$position", position);
        }
        return this.update("$push", key, value);
    }

    public UpdateQueryBuilder updateAddToSet(String key, Object value) {
        return this.update("$addToSet", key, value);
    }

    public UpdateQueryBuilder updateRename(@NonNull Map<String, String> fields) {
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        fields.forEach((key, value) -> this.update("$rename", (String)key, value));
        return this;
    }

    private UpdateQueryBuilder update(String operation, String key, Object value) {
        if (null == this.update) {
            this.update = new HashMap<String, Object>();
        }
        this.update.computeIfAbsent(operation, k -> new HashMap());
        ((Map)this.update.get(operation)).put(key, value);
        return this;
    }

    public UpdateQuery build() {
        return new UpdateQuery(this);
    }

    public static enum ReturnDocument {
        after,
        before;

    }
}

