/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.utils;

import io.stargate.sdk.data.domain.ApiData;
import io.stargate.sdk.data.domain.ApiError;
import io.stargate.sdk.data.domain.ApiResponse;
import io.stargate.sdk.data.exception.DataApiDocumentAlreadyExistException;
import io.stargate.sdk.data.exception.DataApiErrorCode;
import io.stargate.sdk.data.exception.DataApiException;
import io.stargate.sdk.data.exception.DataApiInvalidArgumentException;
import io.stargate.sdk.http.LoadBalancedHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.domain.ApiResponseHttp;
import io.stargate.sdk.utils.AnsiUtils;
import io.stargate.sdk.utils.JsonUtils;
import java.util.function.Function;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataApiUtils {
    private static final Logger log = LoggerFactory.getLogger(DataApiUtils.class);

    private DataApiUtils() {
    }

    public static ApiResponse executeOperation(@NonNull LoadBalancedHttpClient stargateHttpClient, @NonNull Function<ServiceHttp, String> rootResource, @NonNull String operation, Object body) {
        if (stargateHttpClient == null) {
            throw new NullPointerException("stargateHttpClient is marked non-null but is null");
        }
        if (rootResource == null) {
            throw new NullPointerException("rootResource is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        String stringBody = "{\"" + operation + "\":";
        if (body == null) {
            stringBody = stringBody + "{}";
        } else if (body instanceof String) {
            stringBody = stringBody + (String)body;
        } else {
            String obj = JsonUtils.marshallForDataApi((Object)body);
            stringBody = stringBody + obj;
        }
        stringBody = stringBody + "}";
        log.debug(AnsiUtils.magenta((String)operation) + "[request]=" + AnsiUtils.yellow((String)"{}"), (Object)stringBody);
        ApiResponseHttp httpRes = stargateHttpClient.POST(rootResource, stringBody);
        log.debug(AnsiUtils.magenta((String)operation) + "[response]=" + AnsiUtils.yellow((String)"{}"), (Object)httpRes.getBody());
        ApiResponse jsonRes = (ApiResponse)JsonUtils.unmarshallBeanForDataApi((String)httpRes.getBody(), ApiResponse.class);
        if (jsonRes.getData() != null) {
            ApiData data = jsonRes.getData();
            if (data.getDocument() != null) {
                log.debug(AnsiUtils.magenta((String)operation) + "[apiData/document]=" + AnsiUtils.yellow((String)"1 document retrieved, id='{}'"), (Object)data.getDocument().getId());
            }
            if (data.getDocuments() != null) {
                log.debug(AnsiUtils.magenta((String)operation) + "[apiData/documents]=" + AnsiUtils.yellow((String)"{} document(s)."), (Object)data.getDocuments().size());
            }
        }
        if (jsonRes.getStatus() != null && !jsonRes.getStatus().containsKey("insertedIds") || jsonRes.getStatus() == null && jsonRes.getErrors() != null) {
            DataApiUtils.validate(jsonRes);
        }
        return jsonRes;
    }

    public static String buildRequestBody(String function, Object content) {
        return "{\"" + function + "\":" + (content == null ? "{}" : JsonUtils.marshallForDataApi((Object)content)) + "}";
    }

    public static String buildRequestBody(String function) {
        return DataApiUtils.buildRequestBody(function, null);
    }

    public static void validate(@NonNull ApiResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (response.getStatus() == null && response.getErrors() != null && !response.getErrors().isEmpty()) {
            ApiError jsonApiError = response.getErrors().get(0);
            if (log.isDebugEnabled()) {
                log.debug("{} errors detected.", (Object)response.getErrors().size());
                log.debug("[ERROR]");
                log.debug("- message: {}", (Object)jsonApiError.getMessage());
                if (jsonApiError.getExceptionClass() != null) {
                    log.debug("- exceptionClass: {}", (Object)jsonApiError.getExceptionClass());
                }
                if (jsonApiError.getErrorCode() != null) {
                    log.debug("- errorCode: {}", (Object)jsonApiError.getErrorCode());
                }
            }
            if (jsonApiError.getErrorCode() != null) {
                DataApiErrorCode errorCode = DataApiErrorCode.valueOf(jsonApiError.getErrorCode());
                switch (errorCode) {
                    case DOCUMENT_ALREADY_EXISTS: {
                        throw new DataApiDocumentAlreadyExistException(jsonApiError);
                    }
                    case INVALID_COLLECTION_NAME: 
                    case INVALID_FILTER_EXPRESSION: {
                        throw new DataApiInvalidArgumentException(jsonApiError);
                    }
                }
            }
            if (jsonApiError.getExceptionClass() != null && "ConstraintViolationException".equals(jsonApiError.getExceptionClass())) {
                throw new DataApiInvalidArgumentException(jsonApiError);
            }
            throw new DataApiException(jsonApiError);
        }
        if (response.getStatus() != null && response.getStatus().containsKey("ok") && !response.getStatus().get("ok").equals(1)) {
            ApiError error = new ApiError();
            error.setErrorCode("Unexpected error at API Level.");
            error.setMessage(response.getStatus().toString());
            throw new DataApiException(error);
        }
    }
}

