/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.doc;

import com.fasterxml.jackson.core.type.TypeReference;
import io.stargate.sdk.api.ApiResponse;
import io.stargate.sdk.core.DataCenter;
import io.stargate.sdk.doc.CollectionClient;
import io.stargate.sdk.doc.StargateDocumentApiClient;
import io.stargate.sdk.doc.domain.CollectionDefinition;
import io.stargate.sdk.doc.domain.Namespace;
import io.stargate.sdk.http.LoadBalancedHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.domain.ApiResponseHttp;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.JsonUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class NamespaceClient {
    public static final String PATH_COLLECTIONS = "/collections";
    public static final String PATH_FUNCTIONS = "/functions";
    private static final TypeReference<ApiResponse<Namespace>> RESPONSE_NAMESPACE = new TypeReference<ApiResponse<Namespace>>(){};
    private static final TypeReference<ApiResponse<List<CollectionDefinition>>> RESPONSE_COLLECTIONS = new TypeReference<ApiResponse<List<CollectionDefinition>>>(){};
    protected final LoadBalancedHttpClient stargateHttpClient;
    private StargateDocumentApiClient apiDocument;
    private String namespace;
    public Function<ServiceHttp, String> namespaceSchemaResource = node -> this.apiDocument.namespacesSchemaResource.apply((ServiceHttp)node) + "/" + this.namespace;
    public Function<ServiceHttp, String> namespaceResource = node -> this.apiDocument.namespacesResource.apply((ServiceHttp)node) + "/" + this.namespace;
    public Function<ServiceHttp, String> collectionsResource = node -> this.namespaceResource.apply((ServiceHttp)node) + PATH_COLLECTIONS;
    public Function<ServiceHttp, String> functionsResource = node -> this.namespaceSchemaResource.apply((ServiceHttp)node) + PATH_FUNCTIONS;

    public NamespaceClient(LoadBalancedHttpClient stargateHttpClient, StargateDocumentApiClient docClient, String namespace) {
        this.apiDocument = docClient;
        this.namespace = namespace;
        this.stargateHttpClient = stargateHttpClient;
        Assert.notNull((Object)namespace, (String)"namespace");
    }

    public Optional<Namespace> find() {
        ApiResponseHttp res = this.stargateHttpClient.GET(this.namespaceSchemaResource);
        if (404 == res.getCode()) {
            return Optional.empty();
        }
        return Optional.of((Namespace)((ApiResponse)JsonUtils.unmarshallType((String)res.getBody(), RESPONSE_NAMESPACE)).getData());
    }

    public boolean exist() {
        return this.find().isPresent();
    }

    public void create(DataCenter ... datacenters) {
        Assert.notNull((Object)datacenters, (String)"datacenters");
        Assert.isTrue((Boolean)(datacenters.length > 0 ? 1 : 0), (String)"DataCenters are required");
        this.stargateHttpClient.POST(this.apiDocument.namespacesSchemaResource, JsonUtils.marshall((Object)new Namespace(this.namespace, Arrays.asList(datacenters))));
    }

    public void createSimple(int replicas) {
        Assert.isTrue((Boolean)(replicas > 0 ? 1 : 0), (String)"Replica number should be bigger than 0");
        this.stargateHttpClient.POST(this.apiDocument.namespacesSchemaResource, JsonUtils.marshall((Object)new Namespace(this.namespace, replicas)));
    }

    public void delete() {
        this.stargateHttpClient.DELETE(this.namespaceSchemaResource);
    }

    public Stream<CollectionDefinition> collections() {
        ApiResponseHttp res = this.stargateHttpClient.GET(this.collectionsResource);
        return ((List)((ApiResponse)JsonUtils.unmarshallType((String)res.getBody(), RESPONSE_COLLECTIONS)).getData()).stream();
    }

    public Stream<String> collectionNames() {
        return this.collections().map(CollectionDefinition::getName);
    }

    public CollectionClient collection(String collectionName) {
        return new CollectionClient(this.stargateHttpClient, this, collectionName);
    }

    public String getNamespace() {
        return this.namespace;
    }
}

