/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.doc;

import com.fasterxml.jackson.core.type.TypeReference;
import io.stargate.sdk.ServiceDatacenter;
import io.stargate.sdk.ServiceDeployment;
import io.stargate.sdk.api.ApiResponse;
import io.stargate.sdk.api.TokenProvider;
import io.stargate.sdk.doc.NamespaceClient;
import io.stargate.sdk.doc.domain.Namespace;
import io.stargate.sdk.http.LoadBalancedHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.http.auth.TokenProviderHttpAuth;
import io.stargate.sdk.utils.AnsiUtils;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.JsonUtils;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StargateDocumentApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(StargateDocumentApiClient.class);
    public static final String PATH_SCHEMA_NAMESPACES = "/namespaces";
    public static final String PATH_SCHEMA = "/schemas";
    public static final String PATH_V2 = "/v2";
    private static final String DEFAULT_ENDPOINT = "http://localhost:8180";
    private static final String DEFAULT_SERVICE_ID = "sgv2-doc";
    private static final String DEFAULT_DATACENTER = "dc1";
    private static final String PATH_HEALTH_CHECK = "/stargate/health";
    protected final LoadBalancedHttpClient stargateHttpClient;
    public Function<ServiceHttp, String> namespacesSchemaResource = node -> node.getEndpoint() + PATH_V2 + PATH_SCHEMA + PATH_SCHEMA_NAMESPACES;
    public Function<ServiceHttp, String> namespacesResource = node -> node.getEndpoint() + PATH_V2 + PATH_SCHEMA_NAMESPACES;

    public StargateDocumentApiClient() {
        this(DEFAULT_ENDPOINT);
    }

    public StargateDocumentApiClient(String endpoint) {
        Assert.hasLength((String)endpoint, (String)"stargate endpoint");
        ServiceHttp rest = new ServiceHttp(DEFAULT_SERVICE_ID, endpoint, endpoint + PATH_HEALTH_CHECK);
        TokenProviderHttpAuth tokenProvider = new TokenProviderHttpAuth();
        ServiceDatacenter sDc = new ServiceDatacenter(DEFAULT_DATACENTER, (TokenProvider)tokenProvider, Collections.singletonList(rest));
        ServiceDeployment deploy = new ServiceDeployment().addDatacenter(sDc);
        this.stargateHttpClient = new LoadBalancedHttpClient(deploy);
    }

    public StargateDocumentApiClient(ServiceDeployment<ServiceHttp> serviceDeployment) {
        Assert.notNull(serviceDeployment, (String)"service deployment topology");
        this.stargateHttpClient = new LoadBalancedHttpClient(serviceDeployment);
        LOGGER.info("+ API Document :[" + AnsiUtils.green((String)"{}") + "]", (Object)"ENABLED");
    }

    public Stream<Namespace> namespaces() {
        String res = this.stargateHttpClient.GET(this.namespacesSchemaResource).getBody();
        return ((List)((ApiResponse)JsonUtils.unmarshallType((String)res, (TypeReference)new TypeReference<ApiResponse<List<Namespace>>>(){})).getData()).stream();
    }

    public Stream<String> namespaceNames() {
        return this.namespaces().map(Namespace::getName);
    }

    public NamespaceClient namespace(String namespace) {
        return new NamespaceClient(this.stargateHttpClient, this, namespace);
    }

    public LoadBalancedHttpClient getStargateHttpClient() {
        return this.stargateHttpClient;
    }
}

