/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.doc;

import io.stargate.sdk.core.domain.Page;
import io.stargate.sdk.doc.CollectionClient;
import io.stargate.sdk.doc.Document;
import io.stargate.sdk.doc.NamespaceClient;
import io.stargate.sdk.doc.domain.Collection;
import io.stargate.sdk.doc.domain.PageableQuery;
import io.stargate.sdk.doc.domain.Query;
import java.util.Optional;
import java.util.stream.Stream;

public class StargateDocumentRepository<DOC> {
    private final CollectionClient collectionClient;
    private final Class<DOC> docClass;

    public StargateDocumentRepository(CollectionClient col, Class<DOC> clazz) {
        this.collectionClient = col;
        this.docClass = clazz;
    }

    public StargateDocumentRepository(NamespaceClient nc, Class<DOC> clazz) {
        this.docClass = clazz;
        this.collectionClient = new CollectionClient(nc.stargateHttpClient, nc, this.getCollectionName(clazz));
    }

    public long count() {
        return this.collectionClient.count();
    }

    public void delete(String docId) {
        this.collectionClient.document(docId).delete();
    }

    public boolean exists(String docId) {
        return this.collectionClient.document(docId).exist();
    }

    public String insert(DOC p) {
        return this.collectionClient.create(p);
    }

    public void insert(String docId, DOC doc) {
        this.collectionClient.document(docId).upsert(doc);
    }

    public void save(String docId, DOC doc) {
        this.collectionClient.document(docId).upsert(doc);
    }

    public String getCollectionName() {
        return this.collectionClient.getCollectionName();
    }

    public Optional<DOC> find(String docId) {
        return this.collectionClient.document(docId).find(this.docClass);
    }

    public Stream<Document<DOC>> findAll() {
        return this.collectionClient.findAll(this.docClass);
    }

    public Stream<Document<DOC>> findAll(Query query) {
        return this.collectionClient.findAll(query, this.docClass);
    }

    public Page<Document<DOC>> findPage(PageableQuery query) {
        return this.collectionClient.findPage(query, this.docClass);
    }

    private String getCollectionName(Class<DOC> myClass) {
        Collection ann = myClass.getAnnotation(Collection.class);
        if (null != ann && ann.value() != null && !ann.value().equals("")) {
            return ann.value();
        }
        return myClass.getSimpleName().toLowerCase();
    }
}

