/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.doc.domain;

import io.stargate.sdk.doc.domain.PageableQueryBuilder;
import io.stargate.sdk.http.domain.Filter;
import io.stargate.sdk.http.domain.FilterCondition;
import java.util.Collection;

public class PageableQueryBuilderFilter {
    private final String fieldName;
    private final PageableQueryBuilder builder;

    protected PageableQueryBuilderFilter(PageableQueryBuilder builder, String fieldName) {
        this.builder = builder;
        this.fieldName = fieldName;
    }

    private PageableQueryBuilder addFilter(FilterCondition op, Object value) {
        this.builder.filters.add(new Filter(this.fieldName, op, value));
        return this.builder;
    }

    public PageableQueryBuilder isLessThan(Object value) {
        return this.addFilter(FilterCondition.LESS_THAN, value);
    }

    public PageableQueryBuilder isLessOrEqualsThan(Object value) {
        return this.addFilter(FilterCondition.LESS_THAN_OR_EQUALS_TO, value);
    }

    public PageableQueryBuilder isGreaterThan(Object value) {
        return this.addFilter(FilterCondition.GREATER_THAN, value);
    }

    public PageableQueryBuilder isGreaterOrEqualsThan(Object value) {
        return this.addFilter(FilterCondition.GREATER_THAN_OR_EQUALS_TO, value);
    }

    public PageableQueryBuilder isEqualsTo(Object value) {
        return this.addFilter(FilterCondition.EQUALS_TO, value);
    }

    public PageableQueryBuilder isNotEqualsTo(Object value) {
        return this.addFilter(FilterCondition.NOT_EQUALS_TO, value);
    }

    public PageableQueryBuilder exists() {
        return this.addFilter(FilterCondition.EXISTS, null);
    }

    public PageableQueryBuilder isIn(Collection<Object> values) {
        return this.addFilter(FilterCondition.IN, values);
    }
}

